/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.coordination.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.features.distributed.coordination.api.DomainManager;
import org.opennms.features.distributed.coordination.api.DomainManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDomainManagerFactory
implements DomainManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDomainManagerFactory.class);
    private final Map<String, DomainManager> domainManagers = new HashMap<String, DomainManager>();

    protected abstract DomainManager createManagerForDomain(String var1);

    public final synchronized DomainManager getManagerForDomain(String domain) {
        if (!Objects.requireNonNull(domain).matches("^[a-zA-Z0-9.-_]*$")) {
            throw new IllegalArgumentException("Invalid domain");
        }
        if (this.domainManagers.containsKey(domain)) {
            LOG.debug("Returning existing manager for domain {}", (Object)domain);
            return this.domainManagers.get(domain);
        }
        LOG.debug("Creating new manager for domain {}", (Object)domain);
        DomainManager domainManager = this.createManagerForDomain(domain);
        this.domainManagers.put(domain, domainManager);
        return domainManager;
    }

    public String toString() {
        return "AbstractDomainManagerFactory{domainManagers=" + this.domainManagers + '}';
    }
}

