/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.clazzification.shell;

import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.flows.classification.ClassificationService;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.opennms.netmgt.flows.clazzification.shell.GroupCompleter;

@Command(scope="opennms-classification", name="list-rules", description="Lists classification rules stored in the database")
@Service
public class ClassificationListRuleCommand
implements Action {
    @Option(name="-g", aliases={"--group"}, description="Only shows rules for this group")
    @Completion(value=GroupCompleter.class)
    private String group = "user-defined";
    @Reference
    private ClassificationService classificationService;

    public Object execute() throws Exception {
        Criteria criteria = new CriteriaBuilder(Rule.class).alias("group", "group").eq("group.name", (Object)this.group).orderBy("position", true).toCriteria();
        List rules = this.classificationService.findMatchingRules(criteria);
        String TEMPLATE = "%4s   %-20s   %-15s   %10s   %-15s   %-10s   %-15s   %-10s   %-20s   %-15s   %s";
        if (!rules.isEmpty()) {
            System.out.println(String.format("%4s   %-20s   %-15s   %10s   %-15s   %-10s   %-15s   %-10s   %-20s   %-15s   %s", "Pos", "Name", "Protocol", "ID", "Dest. Addr.", "Dest. Port", "Src. Addr.", "Src. Port", "Exporter Filter", "Bidirectional", "Group"));
            for (Rule rule : rules) {
                System.out.println(String.format("%4s   %-20s   %-15s   %10s   %-15s   %-10s   %-15s   %-10s   %-20s   %-15s   %s", rule.getPosition(), rule.getName(), rule.getProtocol() == null ? "" : rule.getProtocol(), rule.getId(), rule.getDstAddress() == null ? "" : rule.getDstAddress(), rule.getDstPort() == null ? "" : rule.getDstPort(), rule.getSrcAddress() == null ? "" : rule.getSrcAddress(), rule.getSrcPort() == null ? "" : rule.getSrcPort(), rule.getExporterFilter() == null ? "" : rule.getExporterFilter(), rule.isOmnidirectional() ? "Y" : "N", rule.getGroup().getName()));
            }
            System.out.println();
        }
        System.out.println("=> " + rules.size() + " rule(s) defined for group '" + this.group + "'");
        return null;
    }
}

