/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.credentials;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXB;
import org.opennms.plugins.elasticsearch.rest.credentials.CredentialsProvider;
import org.opennms.plugins.elasticsearch.rest.credentials.CredentialsScope;
import org.opennms.plugins.elasticsearch.rest.credentials.ElasticCredentials;

public class DefaultCredentialsProvider
implements CredentialsProvider {
    private final Path configPath;

    public DefaultCredentialsProvider(String configName) {
        Path configPath;
        this.configPath = configPath = Paths.get(System.getProperty("opennms.home"), "etc", configName);
    }

    @Override
    public List<CredentialsScope> getCredentials() {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            ElasticCredentials credentialsWrapper = (ElasticCredentials)JAXB.unmarshal((File)this.configPath.toFile(), ElasticCredentials.class);
            return credentialsWrapper.getCredentialsScopes();
        }
        return new ArrayList<CredentialsScope>();
    }
}

