/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dnsresolver.netty;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.SequentialDnsServerAddressStreamProvider;
import io.netty.util.internal.SocketUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.dnsresolver.netty.NettyResolverContext;
import org.opennms.netmgt.dnsresolver.netty.RandomIterator;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyDnsResolver
implements DnsResolver {
    private static final Logger LOG = LoggerFactory.getLogger(NettyDnsResolver.class);
    public static final String CIRCUIT_BREAKER_STATE_CHANGE_EVENT_UEI = "uei.opennms.org/circuitBreaker/stateChange";
    private final EventForwarder eventForwarder;
    private final Timer lookupTimer;
    private final Meter lookupsSuccessful;
    private final Meter lookupsFailed;
    private final Meter lookupsRejectedByCircuitBreaker;
    private int numContexts = 0;
    private String nameservers = null;
    private long queryTimeoutMillis = TimeUnit.SECONDS.toMillis(5L);
    private int minTtlSeconds = -1;
    private int maxTtlSeconds = -1;
    private int negativeTtlSeconds = -1;
    private List<NettyResolverContext> contexts;
    private Iterator<NettyResolverContext> iterator;
    private DnsCache cache;
    private CircuitBreaker circuitBreaker;

    public NettyDnsResolver(EventForwarder eventForwarder, MetricRegistry metrics) {
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
        this.lookupTimer = metrics.timer("lookups");
        this.lookupsSuccessful = metrics.meter("lookupsSuccessful");
        this.lookupsFailed = metrics.meter("lookupsFailed");
        this.lookupsRejectedByCircuitBreaker = metrics.meter("lookupsRejectedByCircuitBreaker");
    }

    public void init() {
        this.numContexts = Math.max(0, this.numContexts);
        if (this.numContexts == 0) {
            this.numContexts = Runtime.getRuntime().availableProcessors() * 2;
        }
        LOG.debug("Initializing Netty resolver with {} contexts and resolvers: {}", (Object)this.numContexts);
        this.contexts = new ArrayList<NettyResolverContext>(this.numContexts);
        DefaultDnsCache cacheWithDefaults = new DefaultDnsCache();
        this.cache = new DefaultDnsCache(this.minTtlSeconds < 0 ? cacheWithDefaults.minTtl() : this.minTtlSeconds, this.maxTtlSeconds < 0 ? cacheWithDefaults.maxTtl() : this.maxTtlSeconds, this.negativeTtlSeconds < 0 ? cacheWithDefaults.negativeTtl() : this.negativeTtlSeconds);
        for (int i = 0; i < this.numContexts; ++i) {
            NettyResolverContext context = new NettyResolverContext(this, this.cache, i);
            context.init();
            this.contexts.add(context);
        }
        this.iterator = new RandomIterator<NettyResolverContext>(this.contexts).iterator();
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold(80.0f).waitDurationInOpenState(Duration.ofSeconds(15L)).ringBufferSizeInHalfOpenState(10).ringBufferSizeInClosedState(100).recordExceptions(new Class[]{DnsNameResolverTimeoutException.class}).build();
        this.circuitBreaker = CircuitBreaker.of((String)"nettyDnsResolver", (CircuitBreakerConfig)circuitBreakerConfig);
        this.circuitBreaker.getEventPublisher().onStateTransition(e -> {
            Event event = new EventBuilder(CIRCUIT_BREAKER_STATE_CHANGE_EVENT_UEI, NettyDnsResolver.class.getCanonicalName()).addParam("name", this.circuitBreaker.getName()).addParam("fromState", e.getStateTransition().getFromState().toString()).addParam("toState", e.getStateTransition().getToState().toString()).getEvent();
            this.eventForwarder.sendNow(event);
        }).onSuccess(e -> this.lookupsSuccessful.mark()).onError(e -> this.lookupsFailed.mark()).onCallNotPermitted(e -> this.lookupsRejectedByCircuitBreaker.mark());
    }

    public void destroy() {
        for (NettyResolverContext context : this.contexts) {
            try {
                context.destroy();
            }
            catch (Exception e) {
                LOG.warn("Error occurred while destroying context.", (Throwable)e);
            }
        }
        this.contexts.clear();
    }

    public CompletableFuture<Optional<InetAddress>> lookup(String hostname) {
        return this.circuitBreaker.executeCompletionStage(() -> {
            NettyResolverContext resolverContext = this.iterator.next();
            Timer.Context timerContext = this.lookupTimer.time();
            return resolverContext.lookup(hostname).whenComplete((res, ex) -> timerContext.stop());
        }).toCompletableFuture();
    }

    public CompletableFuture<Optional<String>> reverseLookup(InetAddress inetAddress) {
        return this.circuitBreaker.executeCompletionStage(() -> {
            NettyResolverContext resolverContext = this.iterator.next();
            Timer.Context timerContext = this.lookupTimer.time();
            return resolverContext.reverseLookup(inetAddress).whenComplete((res, ex) -> timerContext.stop());
        }).toCompletableFuture();
    }

    public int getNumContexts() {
        return this.numContexts;
    }

    public void setNumContexts(int numContexts) {
        this.numContexts = numContexts;
    }

    public String getNameservers() {
        return this.nameservers;
    }

    public void setNameservers(String nameservers) {
        this.nameservers = nameservers;
    }

    public long getQueryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public void setQueryTimeoutMillis(long queryTimeoutMillis) {
        this.queryTimeoutMillis = queryTimeoutMillis;
    }

    public int getMinTtlSeconds() {
        return this.minTtlSeconds;
    }

    public void setMinTtlSeconds(int minTtlSeconds) {
        this.minTtlSeconds = minTtlSeconds;
    }

    public int getMaxTtlSeconds() {
        return this.maxTtlSeconds;
    }

    public void setMaxTtlSeconds(int maxTtlSeconds) {
        this.maxTtlSeconds = maxTtlSeconds;
    }

    public int getNegativeTtlSeconds() {
        return this.negativeTtlSeconds;
    }

    public void setNegativeTtlSeconds(int negativeTtlSeconds) {
        this.negativeTtlSeconds = negativeTtlSeconds;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public DnsServerAddressStreamProvider getNameServerProvider() {
        if (Strings.isNullOrEmpty((String)this.nameservers)) {
            return DnsServerAddressStreamProviders.platformDefault();
        }
        return new SequentialDnsServerAddressStreamProvider(NettyDnsResolver.toSocketAddresses(this.nameservers).toArray(new InetSocketAddress[0]));
    }

    public static List<InetSocketAddress> toSocketAddresses(String commaSeparatedAddressesWithPorts) {
        String[] servers = commaSeparatedAddressesWithPorts.split(",");
        return Arrays.stream(servers).map(s -> {
            HostAndPort hp = HostAndPort.fromString((String)s.trim()).withDefaultPort(53).requireBracketsForIPv6();
            return SocketUtils.socketAddress((String)hp.getHostText(), (int)hp.getPort());
        }).collect(Collectors.toList());
    }
}

