/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.matcher;

import com.google.common.base.Function;
import java.util.Objects;
import org.opennms.core.utils.IPLike;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.internal.matcher.Matcher;
import org.opennms.netmgt.flows.classification.internal.value.StringValue;

class IpMatcher
implements Matcher {
    private final Function<ClassificationRequest, String> valueExtractor;
    private final StringValue value;

    protected IpMatcher(String input, Function<ClassificationRequest, String> valueExtractor) {
        this.value = new StringValue(input);
        this.valueExtractor = Objects.requireNonNull(valueExtractor);
    }

    @Override
    public boolean matches(ClassificationRequest request) {
        if (this.value.isWildcard()) {
            return true;
        }
        String currentAddressValue = (String)this.valueExtractor.apply((Object)request);
        if (this.value.hasWildcard()) {
            return IPLike.matches((String)currentAddressValue, (String)this.value.getValue());
        }
        return this.value.getValue().equals(currentAddressValue);
    }
}

