/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.jti.adapter;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Iterables;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractPersistingAdapter;
import org.opennms.netmgt.telemetry.protocols.collection.CollectionSetWithAgent;
import org.opennms.netmgt.telemetry.protocols.collection.ScriptedCollectionSetBuilder;
import org.opennms.netmgt.telemetry.protocols.jti.adapter.proto.CpuMemoryUtilizationOuterClass;
import org.opennms.netmgt.telemetry.protocols.jti.adapter.proto.FirewallOuterClass;
import org.opennms.netmgt.telemetry.protocols.jti.adapter.proto.LogicalPortOuterClass;
import org.opennms.netmgt.telemetry.protocols.jti.adapter.proto.LspMon;
import org.opennms.netmgt.telemetry.protocols.jti.adapter.proto.LspStatsOuterClass;
import org.opennms.netmgt.telemetry.protocols.jti.adapter.proto.Port;
import org.opennms.netmgt.telemetry.protocols.jti.adapter.proto.TelemetryTop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class JtiGpbAdapter
extends AbstractPersistingAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(JtiGpbAdapter.class);
    private static final ExtensionRegistry s_registry = ExtensionRegistry.newInstance();
    private CollectionAgentFactory collectionAgentFactory;
    private InterfaceToNodeCache interfaceToNodeCache;
    private NodeDao nodeDao;
    private TransactionOperations transactionTemplate;

    public JtiGpbAdapter(String name, MetricRegistry metricRegistry) {
        super(name, metricRegistry);
    }

    public Stream<CollectionSetWithAgent> handleMessage(TelemetryMessageLogEntry message, TelemetryMessageLog messageLog) {
        TelemetryTop.TelemetryStream jtiMsg;
        try {
            jtiMsg = TelemetryTop.TelemetryStream.parseFrom(message.getByteArray(), (ExtensionRegistryLite)s_registry);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.warn("Invalid packet: {}", (Throwable)e);
            return Stream.empty();
        }
        CollectionAgent agent = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(jtiMsg.getSystemId());
            Optional nodeId = this.interfaceToNodeCache.getFirstNodeId(messageLog.getLocation(), inetAddress);
            if (nodeId.isPresent()) {
                agent = this.collectionAgentFactory.createCollectionAgent(Integer.toString((Integer)nodeId.get()), inetAddress);
            }
        }
        catch (UnknownHostException e) {
            LOG.debug("Could not convert system id to address: {}", (Object)jtiMsg.getSystemId());
        }
        if (agent == null) {
            agent = (CollectionAgent)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<CollectionAgent>(){

                public CollectionAgent doInTransaction(TransactionStatus status) {
                    OnmsNode node = (OnmsNode)Iterables.getFirst((Iterable)JtiGpbAdapter.this.nodeDao.findByLabel(jtiMsg.getSystemId()), null);
                    if (node != null) {
                        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
                        return JtiGpbAdapter.this.collectionAgentFactory.createCollectionAgent(primaryInterface);
                    }
                    return null;
                }
            });
        }
        if (agent == null) {
            LOG.warn("Unable to find node and interface for system id: {}", (Object)jtiMsg.getSystemId());
            return Stream.empty();
        }
        ScriptedCollectionSetBuilder builder = this.getCollectionBuilder();
        if (builder == null) {
            LOG.error("Error compiling script '{}'. See logs for details.", (Object)this.getScript());
            return Stream.empty();
        }
        try {
            CollectionSet collectionSet = builder.build(agent, (Object)jtiMsg);
            return Stream.of(new CollectionSetWithAgent(agent, collectionSet));
        }
        catch (ScriptException e) {
            LOG.warn("Error while running script: {}: {}", (Object)this.getScript(), (Object)e);
            return Stream.empty();
        }
    }

    public void setCollectionAgentFactory(CollectionAgentFactory collectionAgentFactory) {
        this.collectionAgentFactory = collectionAgentFactory;
    }

    public void setInterfaceToNodeCache(InterfaceToNodeCache interfaceToNodeCache) {
        this.interfaceToNodeCache = interfaceToNodeCache;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public void setTransactionTemplate(TransactionOperations transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    static {
        CpuMemoryUtilizationOuterClass.registerAllExtensions(s_registry);
        FirewallOuterClass.registerAllExtensions(s_registry);
        LogicalPortOuterClass.registerAllExtensions(s_registry);
        LspMon.registerAllExtensions((ExtensionRegistryLite)s_registry);
        LspStatsOuterClass.registerAllExtensions(s_registry);
        Port.registerAllExtensions(s_registry);
        TelemetryTop.registerAllExtensions(s_registry);
    }
}

