/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.api;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.opennms.features.distributed.kvstore.api.BlobStore;

public final class SerializingBlobStore<V> {
    private final BlobStore blobStore;
    private final Serializer<V> serializer;
    private final Deserializer<V> deserializer;

    public SerializingBlobStore(BlobStore blobStore, Serializer<V> serializer, Deserializer<V> deserializer) {
        this.blobStore = Objects.requireNonNull(blobStore);
        this.serializer = Objects.requireNonNull(serializer);
        this.deserializer = Objects.requireNonNull(deserializer);
    }

    public long put(String key, V value, String context) {
        return this.blobStore.put(key, this.serializer.serialize(value), context);
    }

    public long put(String key, V value, String context, Integer ttlInSeconds) {
        return this.blobStore.put(key, this.serializer.serialize(value), context, ttlInSeconds);
    }

    public Optional<V> get(String key, String context) {
        return this.blobStore.get(key, context).map(this.deserializer::deserialize);
    }

    public Optional<Optional<V>> getIfStale(String key, String context, long timestamp) {
        return this.blobStore.getIfStale(key, context, timestamp).map(o -> o.map(this.deserializer::deserialize));
    }

    public OptionalLong getLastUpdated(String key, String context) {
        return this.blobStore.getLastUpdated(key, context);
    }

    public CompletableFuture<Long> putAsync(String key, V value, String context) {
        return this.blobStore.putAsync(key, this.serializer.serialize(value), context);
    }

    public CompletableFuture<Long> putAsync(String key, V value, String context, Integer ttlInSeconds) {
        return this.blobStore.putAsync(key, this.serializer.serialize(value), context, ttlInSeconds);
    }

    public CompletableFuture<Optional<V>> getAsync(String key, String context) {
        return this.blobStore.getAsync(key, context).thenApply(o -> o.map(this.deserializer::deserialize));
    }

    public CompletableFuture<Optional<Optional<V>>> getIfStaleAsync(String key, String context, long timestamp) {
        return this.blobStore.getIfStaleAsync(key, context, timestamp).thenApply(o -> o.map(ov -> ov.map(this.deserializer::deserialize)));
    }

    public CompletableFuture<OptionalLong> getLastUpdatedAsync(String key, String context) {
        return this.blobStore.getLastUpdatedAsync(key, context);
    }

    @FunctionalInterface
    public static interface Deserializer<V> {
        public V deserialize(byte[] var1);
    }

    @FunctionalInterface
    public static interface Serializer<V> {
        public byte[] serialize(V var1);
    }
}

