/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.Endpoint;
import org.apache.camel.VerifiableComponent;
import org.apache.camel.component.rest.RestComponentVerifier;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

@Metadata(label="verifiers", enums="parameters,connectivity")
public class RestComponent
extends DefaultComponent
implements VerifiableComponent {
    @Metadata(label="common")
    private String componentName;
    @Metadata(label="producer")
    private String apiDoc;
    @Metadata(label="producer")
    private String host;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String uriTemplate;
        String path;
        String restConfigurationName = this.getAndRemoveParameter(parameters, "componentName", String.class, this.componentName);
        RestEndpoint answer = new RestEndpoint(uri, this);
        answer.setComponentName(restConfigurationName);
        answer.setApiDoc(this.apiDoc);
        RestConfiguration config = new RestConfiguration();
        this.mergeConfigurations(config, this.findGlobalRestConfiguration());
        this.mergeConfigurations(config, this.getCamelContext().getRestConfiguration(restConfigurationName, true));
        String h = this.getAndRemoveOrResolveReferenceParameter(parameters, "host", String.class, this.host);
        if (h == null && config != null) {
            h = config.getHost();
            int port = config.getPort();
            if (port > 0 && port != 80 && port != 443) {
                h = h + ":" + port;
            }
        }
        if (h != null && !h.startsWith("http://") && !h.startsWith("https://")) {
            h = "http://" + h;
        }
        answer.setHost(h);
        this.setProperties(answer, parameters);
        if (!parameters.isEmpty()) {
            LinkedHashMap<String, Object> queryParameters = new LinkedHashMap<String, Object>(parameters);
            Map<String, Object> existingQueryParameters = URISupport.parseQuery(answer.getQueryParameters());
            queryParameters.putAll(existingQueryParameters);
            String remainingParameters = URISupport.createQueryString(queryParameters);
            answer.setQueryParameters(remainingParameters);
        }
        answer.setParameters(parameters);
        if (!remaining.contains(":")) {
            throw new IllegalArgumentException("Invalid syntax. Must be rest:method:path[:uriTemplate] where uriTemplate is optional");
        }
        String method = ObjectHelper.before(remaining, ":");
        String s = ObjectHelper.after(remaining, ":");
        if (s != null && s.contains(":")) {
            path = ObjectHelper.before(s, ":");
            uriTemplate = ObjectHelper.after(s, ":");
        } else {
            path = s;
            uriTemplate = null;
        }
        path = FileUtil.stripTrailingSeparator(path);
        uriTemplate = FileUtil.stripTrailingSeparator(uriTemplate);
        answer.setMethod(method);
        answer.setPath(path);
        answer.setUriTemplate(uriTemplate);
        if (answer.getComponentName() == null && config != null) {
            String name = config.getProducerComponent();
            if (name == null) {
                name = config.getComponent();
            }
            answer.setComponentName(name);
        }
        if (answer.getApiDoc() == null && config != null) {
            answer.setApiDoc(config.getProducerApiDoc());
        }
        return answer;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getApiDoc() {
        return this.apiDoc;
    }

    public void setApiDoc(String apiDoc) {
        this.apiDoc = apiDoc;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    private RestConfiguration findGlobalRestConfiguration() {
        CamelContext context = this.getCamelContext();
        RestConfiguration conf = CamelContextHelper.lookup(context, "rest-configuration", RestConfiguration.class);
        if (conf == null) {
            conf = CamelContextHelper.findByType(this.getCamelContext(), RestConfiguration.class);
        }
        return conf;
    }

    private RestConfiguration mergeConfigurations(RestConfiguration conf, RestConfiguration from) throws Exception {
        if (from != null) {
            Map<String, Object> map = IntrospectionSupport.getNonNullProperties(from);
            Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                if (!(entry.getValue() instanceof Map)) continue;
                it.remove();
            }
            IntrospectionSupport.setProperties(this.getCamelContext(), this.getCamelContext().getTypeConverter(), conf, map);
            this.mergeProperties(conf::getComponentProperties, from::getComponentProperties, conf::setComponentProperties);
            this.mergeProperties(conf::getEndpointProperties, from::getEndpointProperties, conf::setEndpointProperties);
            this.mergeProperties(conf::getConsumerProperties, from::getConsumerProperties, conf::setConsumerProperties);
            this.mergeProperties(conf::getDataFormatProperties, from::getDataFormatProperties, conf::setDataFormatProperties);
            this.mergeProperties(conf::getApiProperties, from::getApiProperties, conf::setApiProperties);
            this.mergeProperties(conf::getCorsHeaders, from::getCorsHeaders, conf::setCorsHeaders);
        }
        return conf;
    }

    private <T> void mergeProperties(Supplier<Map<String, T>> base, Supplier<Map<String, T>> addons, Consumer<Map<String, T>> consumer) {
        Map<String, T> baseMap = base.get();
        Map<String, T> addonsMap = addons.get();
        if (baseMap != null || addonsMap != null) {
            HashMap<String, T> result = new HashMap<String, T>();
            if (baseMap != null) {
                result.putAll(baseMap);
            }
            if (addonsMap != null) {
                result.putAll(addonsMap);
            }
            consumer.accept(result);
        }
    }

    @Override
    public ComponentVerifier getVerifier() {
        return new RestComponentVerifier(this);
    }
}

