/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.blob.shell;

import java.util.Objects;
import java.util.Optional;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.distributed.kvstore.api.BlobStore;

@Command(scope="opennms-kv-blob", name="get", description="Get a record from the blob store decoded as a string")
@Service
public class BlobStoreGet
implements Action {
    @Reference
    private BlobStore blobStore;
    @Argument(index=0, description="The key to look up")
    private String key;
    @Argument(index=1, description="The key's context")
    private String context;

    public Object execute() {
        Objects.requireNonNull(this.key);
        Objects.requireNonNull(this.context);
        Optional value = this.blobStore.get(this.key, this.context);
        if (value.isPresent()) {
            System.out.println(new String((byte[])value.get()));
        } else {
            System.out.println(String.format("Value for key '%s' could not be found", this.key));
        }
        return null;
    }
}

