/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.AbstractCollectionResource;
import org.opennms.netmgt.collection.support.ConstantTimeKeeper;
import org.opennms.netmgt.collection.support.NumericAttributeUtils;
import org.opennms.netmgt.collection.support.builder.Attribute;
import org.opennms.netmgt.collection.support.builder.NumericAttribute;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.collection.support.builder.StringAttribute;
import org.opennms.netmgt.model.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionSetBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionSetBuilder.class);
    private final CollectionAgent m_agent;
    private CollectionStatus m_status = CollectionStatus.SUCCEEDED;
    private Date m_timestamp = new Date();
    private Map<Resource, List<Attribute<?>>> m_attributesByResource = new LinkedHashMap();
    private boolean m_disableCounterPersistence = false;

    public CollectionSetBuilder(CollectionAgent agent) {
        this.m_agent = Objects.requireNonNull(agent, "agent cannot be null");
    }

    public CollectionSetBuilder withStatus(CollectionStatus status) {
        this.m_status = Objects.requireNonNull(status, "status cannot be null");
        return this;
    }

    public CollectionSetBuilder withTimestamp(Date timestamp) {
        this.m_timestamp = Objects.requireNonNull(timestamp, "timestamp cannot be null");
        return this;
    }

    public CollectionSetBuilder withGauge(Resource resource, String group, String name, Number value) {
        return this.withAttribute(resource, new NumericAttribute(group, name, value, AttributeType.GAUGE, null));
    }

    public CollectionSetBuilder withCounter(Resource resource, String group, String name, Number value) {
        return this.withAttribute(resource, new NumericAttribute(group, name, value, AttributeType.COUNTER, null));
    }

    public CollectionSetBuilder withNumericAttribute(Resource resource, String group, String name, Number value, AttributeType type) {
        return this.withAttribute(resource, new NumericAttribute(group, name, value, type, null));
    }

    public CollectionSetBuilder withStringAttribute(Resource resource, String group, String name, String value) {
        return this.withAttribute(resource, new StringAttribute(group, name, value, null));
    }

    public CollectionSetBuilder withIdentifiedNumericAttribute(Resource resource, String group, String name, Number value, AttributeType type, String metricId) {
        return this.withAttribute(resource, new NumericAttribute(group, name, value, type, metricId));
    }

    public CollectionSetBuilder withIdentifiedStringAttribute(Resource resource, String group, String name, String value, String metricId) {
        return this.withAttribute(resource, new StringAttribute(group, name, value, metricId));
    }

    public CollectionSetBuilder withAttribute(Resource resource, String group, String name, String value, AttributeType type) {
        if (value == null) {
            LOG.info("Ignoring null value for attribute '{}' in group '{}' on resource '{}'", new Object[]{name, group, resource});
            return this;
        }
        if (type.isNumeric()) {
            return this.withNumericAttribute(resource, group, name, NumericAttributeUtils.parseNumericValue(value), type);
        }
        return this.withStringAttribute(resource, group, name, value);
    }

    private CollectionSetBuilder withAttribute(Resource resource, Attribute<?> attribute) {
        if (this.m_attributesByResource.containsKey(resource)) {
            this.m_attributesByResource.get(resource).add(attribute);
        } else {
            ArrayList attributes = new ArrayList();
            attributes.add(attribute);
            this.m_attributesByResource.put(resource, attributes);
        }
        return this;
    }

    public CollectionSetBuilder disableCounterPersistence(boolean disableCounterPersistence) {
        this.m_disableCounterPersistence = disableCounterPersistence;
        return this;
    }

    public CollectionSetDTO build() {
        return new CollectionSetDTO(this.m_agent, this.m_status, this.m_timestamp, this.m_attributesByResource, this.m_disableCounterPersistence);
    }

    public static AbstractCollectionResource toCollectionResource(final Resource resource, CollectionAgent agent) {
        return new AbstractCollectionResource(agent){
            private String label;

            @Override
            public String getResourceTypeName() {
                return resource.getTypeName();
            }

            @Override
            public String getInstance() {
                return resource.getInstance();
            }

            @Override
            public String getUnmodifiedInstance() {
                return resource.getUnmodifiedInstance();
            }

            @Override
            public synchronized String getInterfaceLabel() {
                if (this.label == null) {
                    this.label = resource.getLabel(this);
                }
                return this.label;
            }

            @Override
            public ResourcePath getPath() {
                return ResourcePath.get((ResourcePath)super.getPath(), (Iterable)resource.getPath(this));
            }

            @Override
            public TimeKeeper getTimeKeeper() {
                if (resource.getTimestamp() != null) {
                    return new ConstantTimeKeeper(resource.getTimestamp());
                }
                return null;
            }

            public String toString() {
                return resource.toString();
            }
        };
    }

    public int getNumResources() {
        return this.m_attributesByResource.keySet().size();
    }

    public int getNumAttributes() {
        return this.m_attributesByResource.values().stream().mapToInt(attrs -> attrs.size()).sum();
    }
}

