/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.utils.mate;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.core.rpc.utils.mate.ContextKey;
import org.opennms.core.rpc.utils.mate.EmptyScope;
import org.opennms.core.rpc.utils.mate.EntityScopeProvider;
import org.opennms.core.rpc.utils.mate.FallbackScope;
import org.opennms.core.rpc.utils.mate.MapScope;
import org.opennms.core.rpc.utils.mate.ObjectScope;
import org.opennms.core.rpc.utils.mate.Scope;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityScopeProviderImpl
implements EntityScopeProvider {
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao monitoredServiceDao;
    @Autowired
    private SessionUtils sessionUtils;

    @Override
    public Scope getScopeForNode(Integer nodeId) {
        if (nodeId == null) {
            return EmptyScope.EMPTY;
        }
        Scope metaDataScope = (Scope)this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)nodeId);
            if (node == null) {
                return EmptyScope.EMPTY;
            }
            return new FallbackScope(EntityScopeProviderImpl.transform(node.getMetaData()), new ObjectScope<OnmsNode>(node).map("node", "label", n -> Optional.ofNullable(n.getLabel())).map("node", "foreign-source", n -> Optional.ofNullable(n.getForeignSource())).map("node", "foreign-id", n -> Optional.ofNullable(n.getForeignId())).map("node", "netbios-domain", n -> Optional.ofNullable(n.getNetBiosDomain())).map("node", "netbios-name", n -> Optional.ofNullable(n.getNetBiosName())).map("node", "os", n -> Optional.ofNullable(n.getOperatingSystem())).map("node", "sys-name", n -> Optional.ofNullable(n.getSysName())).map("node", "sys-location", n -> Optional.ofNullable(n.getSysLocation())).map("node", "sys-contact", n -> Optional.ofNullable(n.getSysContact())).map("node", "sys-description", n -> Optional.ofNullable(n.getSysDescription())).map("node", "location", n -> Optional.ofNullable(n.getLocation().getLocationName())).map("node", "area", n -> Optional.ofNullable(n.getLocation().getMonitoringArea())));
        });
        return metaDataScope;
    }

    @Override
    public Scope getScopeForInterface(Integer nodeId, String ipAddress) {
        if (nodeId == null || Strings.isNullOrEmpty((String)ipAddress)) {
            return EmptyScope.EMPTY;
        }
        Scope metaDataScope = (Scope)this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsIpInterface ipInterface = this.ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddress);
            if (ipInterface == null) {
                return EmptyScope.EMPTY;
            }
            return new FallbackScope(EntityScopeProviderImpl.transform(ipInterface.getMetaData()), new ObjectScope<OnmsIpInterface>(ipInterface).map("interface", "hostname", i -> Optional.ofNullable(i.getIpHostName())).map("interface", "address", i -> Optional.ofNullable(i.getIpAddress()).map(InetAddressUtils::toIpAddrString)).map("interface", "netmask", i -> Optional.ofNullable(i.getNetMask()).map(InetAddressUtils::toIpAddrString)).map("interface", "if-index", i -> Optional.ofNullable(i.getIfIndex()).map(Object::toString)).map("interface", "if-alias", i -> Optional.ofNullable(i.getSnmpInterface()).map(OnmsSnmpInterface::getIfAlias)).map("interface", "if-description", i -> Optional.ofNullable(i.getSnmpInterface()).map(OnmsSnmpInterface::getIfDescr)).map("interface", "phy-addr", i -> Optional.ofNullable(i.getSnmpInterface()).map(OnmsSnmpInterface::getPhysAddr)));
        });
        return metaDataScope;
    }

    @Override
    public Scope getScopeForService(Integer nodeId, InetAddress ipAddress, String serviceName) {
        if (nodeId == null || ipAddress == null || Strings.isNullOrEmpty((String)serviceName)) {
            return EmptyScope.EMPTY;
        }
        Scope metaDataScope = (Scope)this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsMonitoredService monitoredService = this.monitoredServiceDao.get(nodeId, ipAddress, serviceName);
            if (monitoredService == null) {
                return EmptyScope.EMPTY;
            }
            return new FallbackScope(EntityScopeProviderImpl.transform(monitoredService.getMetaData()), new ObjectScope<OnmsMonitoredService>(monitoredService).map("service", "name", s -> Optional.of(s.getServiceName())));
        });
        return metaDataScope;
    }

    private static MapScope transform(Collection<OnmsMetaData> metaData) {
        Map<ContextKey, String> map = metaData.stream().collect(Collectors.toMap(e -> new ContextKey(e.getContext(), e.getKey()), e -> e.getValue()));
        return new MapScope(map);
    }
}

