/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.api;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.opennms.features.distributed.kvstore.api.KeyValueStore;

public final class SerializingKeyValueStore<V> {
    private final KeyValueStore keyValueStore;
    private final Serializer<V> serializer;
    private final Deserializer<V> deserializer;

    public SerializingKeyValueStore(KeyValueStore keyValueStore, Serializer<V> serializer, Deserializer<V> deserializer) {
        this.keyValueStore = Objects.requireNonNull(keyValueStore);
        this.serializer = Objects.requireNonNull(serializer);
        this.deserializer = Objects.requireNonNull(deserializer);
    }

    public long put(String key, V value, String context) {
        return this.keyValueStore.put(key, this.serializer.serialize(value), context);
    }

    public long put(String key, V value, String context, Integer ttlInSeconds) {
        return this.keyValueStore.put(key, this.serializer.serialize(value), context, ttlInSeconds);
    }

    public Optional<V> get(String key, String context) {
        return this.keyValueStore.get(key, context).map(this.deserializer::deserialize);
    }

    public Optional<Optional<V>> getIfStale(String key, String context, long timestamp) {
        return this.keyValueStore.getIfStale(key, context, timestamp).map(o -> o.map(this.deserializer::deserialize));
    }

    public OptionalLong getLastUpdated(String key, String context) {
        return this.keyValueStore.getLastUpdated(key, context);
    }

    public CompletableFuture<Long> putAsync(String key, V value, String context) {
        return this.keyValueStore.putAsync(key, this.serializer.serialize(value), context);
    }

    public CompletableFuture<Long> putAsync(String key, V value, String context, Integer ttlInSeconds) {
        return this.keyValueStore.putAsync(key, this.serializer.serialize(value), context, ttlInSeconds);
    }

    public CompletableFuture<Optional<V>> getAsync(String key, String context) {
        return this.keyValueStore.getAsync(key, context).thenApply(o -> o.map(this.deserializer::deserialize));
    }

    public CompletableFuture<Optional<Optional<V>>> getIfStaleAsync(String key, String context, long timestamp) {
        return this.keyValueStore.getIfStaleAsync(key, context, timestamp).thenApply(o -> o.map(ov -> ov.map(this.deserializer::deserialize)));
    }

    public CompletableFuture<OptionalLong> getLastUpdatedAsync(String key, String context) {
        return this.keyValueStore.getLastUpdatedAsync(key, context);
    }

    @FunctionalInterface
    public static interface Deserializer<V> {
        public V deserialize(byte[] var1);
    }

    @FunctionalInterface
    public static interface Serializer<V> {
        public byte[] serialize(V var1);
    }
}

