/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.api;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.opennms.features.distributed.kvstore.api.AbstractKeyValueStore;

public abstract class AbstractAsyncKeyValueStore
extends AbstractKeyValueStore {
    private final Executor executor;

    protected AbstractAsyncKeyValueStore(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    protected AbstractAsyncKeyValueStore() {
        this(Executors.newCachedThreadPool(r -> new Thread(r, "kvstore-async-thread")));
    }

    @Override
    public final CompletableFuture<Long> putAsync(String key, byte[] value, String context, Integer ttlInSeconds) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> this.put(key, value, context, ttlInSeconds), this.executor);
    }

    @Override
    public final CompletableFuture<Optional<byte[]>> getAsync(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> this.get(key, context), this.executor);
    }

    @Override
    public final CompletableFuture<Optional<Optional<byte[]>>> getIfStaleAsync(String key, String context, long timestamp) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> this.getIfStale(key, context, timestamp));
    }

    @Override
    public final CompletableFuture<OptionalLong> getLastUpdatedAsync(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> this.getLastUpdated(key, context), this.executor);
    }
}

