/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow9;

import java.util.Objects;
import java.util.Optional;
import org.bson.BsonDocument;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.telemetry.protocols.common.utils.BsonUtils;

class Netflow9Flow
implements Flow {
    private final BsonDocument document;

    public Netflow9Flow(BsonDocument document) {
        this.document = Objects.requireNonNull(document);
    }

    public long getTimestamp() {
        return (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@unixSecs"}).get() * 1000L;
    }

    public Long getBytes() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"IN_BYTES"}).orElse(null);
    }

    public Flow.Direction getDirection() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"DIRECTION"}).map(v -> v == 0L ? Flow.Direction.INGRESS : (v == 1L ? Flow.Direction.EGRESS : null)).orElse(null);
    }

    public String getDstAddr() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV6_DST_ADDR", "address"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV4_DST_ADDR", "address"})}).orElse(null);
    }

    public Optional<String> getDstAddrHostname() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV6_DST_ADDR", "hostname"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV4_DST_ADDR", "hostname"})});
    }

    public Long getDstAs() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"DST_AS"}).orElse(null);
    }

    public Integer getDstMaskLen() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"IPV6_DST_MASK"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"DST_MASK"})}).map(Long::intValue).orElse(null);
    }

    public Integer getDstPort() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"L4_DST_PORT"}).map(Long::intValue).orElse(null);
    }

    public Integer getEngineId() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"ENGINE_ID"}).map(Long::intValue).orElse(null);
    }

    public Integer getEngineType() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"ENGINE_TYPE"}).map(Long::intValue).orElse(null);
    }

    public Long getFirstSwitched() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"FIRST_SWITCHED"}).map(t -> this.getBootTime() + t).orElse(null);
    }

    public int getFlowRecords() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@recordCount"}).map(Long::intValue).orElse(0);
    }

    public long getFlowSeqNum() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@sequenceNumber"}).orElse(0L);
    }

    public Integer getInputSnmp() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"INPUT_SNMP"}).map(Long::intValue).orElse(null);
    }

    public Integer getIpProtocolVersion() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"IP_PROTOCOL_VERSION"}).map(Long::intValue).orElse(null);
    }

    public Long getLastSwitched() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"LAST_SWITCHED"}).map(t -> this.getBootTime() + t).orElse(null);
    }

    public String getNextHop() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV6_NEXT_HOP", "address"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV4_NEXT_HOP", "address"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"BPG_IPV6_NEXT_HOP", "address"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"BPG_IPV4_NEXT_HOP", "address"})}).orElse(null);
    }

    public Optional<String> getNextHopHostname() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV6_NEXT_HOP", "hostname"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV4_NEXT_HOP", "hostname"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"BPG_IPV6_NEXT_HOP", "hostname"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"BPG_IPV4_NEXT_HOP", "hostname"})});
    }

    public Integer getOutputSnmp() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"OUTPUT_SNMP"}).map(Long::intValue).orElse(null);
    }

    public Long getPackets() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"IN_PKTS"}).orElse(null);
    }

    public Integer getProtocol() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"PROTOCOL"}).map(Long::intValue).orElse(null);
    }

    public Flow.SamplingAlgorithm getSamplingAlgorithm() {
        int samplingAlgorithm = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"SAMPLING_ALGORITHM"}).map(Long::intValue).orElse(0);
        if (samplingAlgorithm == 1) {
            return Flow.SamplingAlgorithm.SystematicCountBasedSampling;
        }
        if (samplingAlgorithm == 2) {
            return Flow.SamplingAlgorithm.RandomNoutOfNSampling;
        }
        return Flow.SamplingAlgorithm.Unassigned;
    }

    public Double getSamplingInterval() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"SAMPLING_INTERVAL"}).map(Long::doubleValue).orElse(null);
    }

    public String getSrcAddr() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV6_SRC_ADDR", "address"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV4_SRC_ADDR", "address"})}).orElse(null);
    }

    public Optional<String> getSrcAddrHostname() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV6_SRC_ADDR", "hostname"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"IPV4_SRC_ADDR", "hostname"})});
    }

    public Long getSrcAs() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"SRC_AS"}).orElse(null);
    }

    public Integer getSrcMaskLen() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"IPV6_SRC_MASK"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"SRC_MASK"})}).map(Long::intValue).orElse(null);
    }

    public Integer getSrcPort() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"L4_SRC_PORT"}).map(Long::intValue).orElse(null);
    }

    public Integer getTcpFlags() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"TCP_FLAGS"}).map(Long::intValue).orElse(null);
    }

    public Integer getTos() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"TOS"}).map(Long::intValue).orElse(null);
    }

    public Flow.NetflowVersion getNetflowVersion() {
        return Flow.NetflowVersion.V9;
    }

    public Integer getVlan() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"SRC_VLAN"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"DST_VLAN"})}).map(Long::intValue).orElse(null);
    }

    private long getSysUpTime() {
        return (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@sysUpTime"}).get();
    }

    private long getBootTime() {
        return this.getTimestamp() - this.getSysUpTime();
    }
}

