/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow5;

import java.util.Objects;
import java.util.Optional;
import org.bson.BsonDocument;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.telemetry.protocols.common.utils.BsonUtils;

class Netflow5Flow
implements Flow {
    private final BsonDocument document;

    public Netflow5Flow(BsonDocument document) {
        this.document = Objects.requireNonNull(document);
    }

    public long getTimestamp() {
        return (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@unixSecs"}).get() * 1000L + (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@unixNSecs"}).get() / 1000000L;
    }

    public Long getBytes() {
        return (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"dOctets"}).get();
    }

    public Flow.Direction getDirection() {
        return (Boolean)BsonUtils.getBool((BsonDocument)this.document, (String[])new String[]{"egress"}).get() != false ? Flow.Direction.EGRESS : Flow.Direction.INGRESS;
    }

    public String getDstAddr() {
        return (String)BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"dstAddr", "address"}).get();
    }

    public Optional<String> getDstAddrHostname() {
        return BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"dstAddr", "hostname"});
    }

    public Long getDstAs() {
        return (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"dstAs"}).get();
    }

    public Integer getDstMaskLen() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"dstMask"}).map(Long::intValue).get();
    }

    public Integer getDstPort() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"dstPort"}).map(Long::intValue).get();
    }

    public Integer getEngineId() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@engineId"}).map(Long::intValue).get();
    }

    public Integer getEngineType() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@engineType"}).map(Long::intValue).get();
    }

    public Long getFirstSwitched() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"first"}).map(t -> this.getBootTime() + t).get();
    }

    public int getFlowRecords() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@count"}).map(Long::intValue).get();
    }

    public long getFlowSeqNum() {
        return (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@flowSequence"}).get();
    }

    public Integer getInputSnmp() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"input"}).map(Long::intValue).get();
    }

    public Integer getIpProtocolVersion() {
        return 4;
    }

    public Long getLastSwitched() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"last"}).map(t -> this.getBootTime() + t).get();
    }

    public String getNextHop() {
        return (String)BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"nextHop", "address"}).get();
    }

    public Optional<String> getNextHopHostname() {
        return BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"nextHop", "hostname"});
    }

    public Integer getOutputSnmp() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"output"}).map(Long::intValue).get();
    }

    public Long getPackets() {
        return (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"dPkts"}).get();
    }

    public Integer getProtocol() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"proto"}).map(Long::intValue).get();
    }

    public Flow.SamplingAlgorithm getSamplingAlgorithm() {
        switch (BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@samplingAlgorithm"}).map(Long::intValue).get()) {
            case 1: {
                return Flow.SamplingAlgorithm.SystematicCountBasedSampling;
            }
            case 2: {
                return Flow.SamplingAlgorithm.RandomNoutOfNSampling;
            }
        }
        return Flow.SamplingAlgorithm.Unassigned;
    }

    public Double getSamplingInterval() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@samplingInterval"}).map(Long::doubleValue).get();
    }

    public String getSrcAddr() {
        return (String)BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"srcAddr", "address"}).get();
    }

    public Optional<String> getSrcAddrHostname() {
        return BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"srcAddr", "hostname"});
    }

    public Long getSrcAs() {
        return (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"srcAs"}).get();
    }

    public Integer getSrcMaskLen() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"srcMask"}).map(Long::intValue).get();
    }

    public Integer getSrcPort() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"srcPort"}).map(Long::intValue).get();
    }

    public Integer getTcpFlags() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"tcpFlags"}).map(Long::intValue).get();
    }

    public Integer getTos() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"tos"}).map(Long::intValue).get();
    }

    public Flow.NetflowVersion getNetflowVersion() {
        return Flow.NetflowVersion.V5;
    }

    public Integer getVlan() {
        return null;
    }

    private long getSysUpTime() {
        return (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@sysUptime"}).get();
    }

    private long getBootTime() {
        return this.getTimestamp() - this.getSysUpTime();
    }
}

