/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.camel.server;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.camel.server.CamelSinkServerProcessor;
import org.opennms.core.ipc.sink.common.AbstractMessageConsumerManager;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.distributed.core.api.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CamelMessageConsumerManager
extends AbstractMessageConsumerManager {
    private static final Logger LOG = LoggerFactory.getLogger(CamelMessageConsumerManager.class);
    private final CamelContext context;
    private final Map<SinkModule<?, Message>, String> routeIdsByModule = new ConcurrentHashMap();
    @Autowired
    private TracerRegistry tracerRegistry;
    @Autowired
    private Identity identity;

    public CamelMessageConsumerManager(CamelContext context) throws Exception {
        this.context = Objects.requireNonNull(context);
        context.start();
    }

    public CamelMessageConsumerManager(CamelContext context, Identity identity, TracerRegistry tracerRegistry) throws Exception {
        this.context = Objects.requireNonNull(context);
        this.identity = Objects.requireNonNull(identity);
        this.tracerRegistry = Objects.requireNonNull(tracerRegistry);
    }

    protected synchronized void startConsumingForModule(SinkModule<?, Message> module) throws Exception {
        if (!this.routeIdsByModule.containsKey(module)) {
            LOG.info("Creating route for module: {}", module);
            DynamicIpcRouteBuilder routeBuilder = new DynamicIpcRouteBuilder(this.context, this, module, this.tracerRegistry);
            this.context.addRoutes((RoutesBuilder)routeBuilder);
            this.routeIdsByModule.put(module, routeBuilder.getRouteId());
        }
    }

    protected synchronized void stopConsumingForModule(SinkModule<?, Message> module) throws Exception {
        if (this.routeIdsByModule.containsKey(module)) {
            LOG.info("Destroying route for module: {}", module);
            String routeId = this.routeIdsByModule.remove(module);
            this.context.stopRoute(routeId);
            this.context.removeRoute(routeId);
        }
    }

    public void setTracerRegistry(TracerRegistry tracerRegistry) {
        this.tracerRegistry = tracerRegistry;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public void start() {
        if (this.tracerRegistry != null && this.identity != null) {
            this.tracerRegistry.init(this.identity.getId());
        }
    }

    private static final class DynamicIpcRouteBuilder
    extends RouteBuilder {
        private final CamelMessageConsumerManager consumerManager;
        private final SinkModule<?, Message> module;
        private final TracerRegistry tracerRegistry;

        private DynamicIpcRouteBuilder(CamelContext context, CamelMessageConsumerManager consumerManager, SinkModule<?, Message> module, TracerRegistry tracerRegistry) {
            super(context);
            this.consumerManager = consumerManager;
            this.module = module;
            this.tracerRegistry = tracerRegistry;
        }

        public String getRouteId() {
            return "Sink.Server." + this.module.getId();
        }

        public void configure() throws Exception {
            int numberConsumerThrads = AbstractMessageConsumerManager.getNumConsumerThreads(this.module);
            JmsQueueNameFactory queueNameFactory = new JmsQueueNameFactory("Sink", this.module.getId());
            ((RouteDefinition)((RouteDefinition)this.from(String.format("queuingservice:%s?concurrentConsumers=%d", queueNameFactory.getName(), numberConsumerThrads)).setExchangePattern(ExchangePattern.InOnly)).process((Processor)new CamelSinkServerProcessor(this.consumerManager, this.module, this.tracerRegistry))).routeId(this.getRouteId());
        }
    }
}

