/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.opennms.core.utils.PropertiesCache;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

public abstract class RrdResourceAttributeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RrdResourceAttributeUtils.class);
    public static final String DS_PROPERTIES_FILE = "ds.properties";
    public static final String STRINGS_PROPERTIES_FILE_NAME = "strings.properties";
    private static final PropertiesCache s_cache = new PropertiesCache();

    protected static Set<OnmsAttribute> getAttributesAtRelativePath(File rrdDirectory, String relativePath, String rrdFileSuffix) {
        HashSet<OnmsAttribute> attributes = new HashSet<OnmsAttribute>();
        RrdResourceAttributeUtils.loadRrdAttributes(rrdDirectory, relativePath, attributes, rrdFileSuffix);
        RrdResourceAttributeUtils.loadStringAttributes(rrdDirectory, relativePath, attributes);
        return attributes;
    }

    private static void loadStringAttributes(File rrdDirectory, String relativePath, Set<OnmsAttribute> attributes) {
        Properties properties = RrdResourceAttributeUtils.getStringProperties(rrdDirectory, relativePath);
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                attributes.add((OnmsAttribute)new StringPropertyAttribute(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
    }

    private static void loadRrdAttributes(File rrdDirectory, String relativePath, Set<OnmsAttribute> attributes, final String rrdFileSuffix) {
        int suffixLength = rrdFileSuffix.length();
        File resourceDir = new File(rrdDirectory, relativePath);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(rrdFileSuffix);
            }
        };
        File[] files = resourceDir.listFiles(filter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (ResourceTypeUtils.isStoreByGroup() && !ResourceTypeUtils.isResponseTime((String)relativePath)) {
                String groupName = fileName.substring(0, fileName.length() - suffixLength);
                Properties props = RrdResourceAttributeUtils.getDsProperties(resourceDir);
                for (Object o : props.keySet()) {
                    String dsName = (String)o;
                    if (!props.getProperty(dsName).equals(groupName)) continue;
                    attributes.add((OnmsAttribute)new RrdGraphAttribute(dsName, relativePath, fileName));
                }
                continue;
            }
            String dsName = fileName.substring(0, fileName.length() - suffixLength);
            attributes.add((OnmsAttribute)new RrdGraphAttribute(dsName, relativePath, fileName));
        }
    }

    protected static Properties getDsProperties(File directory) {
        File propertiesFile = new File(directory, DS_PROPERTIES_FILE);
        try {
            return s_cache.getProperties(propertiesFile);
        }
        catch (IOException e) {
            LOG.error("ds.properties error", (Throwable)e);
            return new Properties();
        }
    }

    protected static File getRrdFileForDs(File directory, String ds, String extension) {
        String rrdBaseName = ds;
        if (ResourceTypeUtils.isStoreByGroup()) {
            try {
                rrdBaseName = s_cache.getProperty(new File(directory, DS_PROPERTIES_FILE), ds);
            }
            catch (IOException e) {
                LOG.error("ds.properties error", (Throwable)e);
                rrdBaseName = ds;
            }
        }
        return new File(directory, rrdBaseName + extension);
    }

    protected static Properties getStringProperties(File rrdDirectory, String relativePath) {
        Assert.notNull((Object)rrdDirectory, (String)"rrdDirectory argument must not be null");
        Assert.notNull((Object)relativePath, (String)"relativePath argument must not be null");
        File resourceDir = new File(rrdDirectory, relativePath);
        return RrdResourceAttributeUtils.getStringProperties(resourceDir);
    }

    private static Properties getStringProperties(File resourceDir) {
        Assert.notNull((Object)resourceDir, (String)"resourceDir argumnet must not be null");
        return RrdResourceAttributeUtils.getProperties(new File(resourceDir, STRINGS_PROPERTIES_FILE_NAME));
    }

    protected static Properties getProperties(File file) {
        try {
            return s_cache.findProperties(file);
        }
        catch (IOException e) {
            String message = "loadProperties: Error opening properties file " + file.getAbsolutePath() + ": " + e;
            LOG.warn(message, (Throwable)e);
            throw new DataAccessResourceFailureException(message, (Throwable)e);
        }
    }

    protected static void saveUpdatedProperties(File propertiesFile, Properties props) throws FileNotFoundException, IOException {
        s_cache.saveProperties(propertiesFile, props);
    }

    protected static void updateDsProperties(File resourceDir, Map<String, String> dsNamesToRrdNames) {
        try {
            s_cache.updateProperties(new File(resourceDir, DS_PROPERTIES_FILE), dsNamesToRrdNames);
        }
        catch (IOException e) {
            LOG.error("Unable to save DataSource Properties file", (Throwable)e);
        }
    }

    protected static void updateStringProperty(File resourceDir, String attrVal, String attrName) throws FileNotFoundException, IOException {
        File propertiesFile = new File(resourceDir, STRINGS_PROPERTIES_FILE_NAME);
        s_cache.setProperty(propertiesFile, attrName, attrVal);
    }

    protected static String getStringProperty(File directory, String key) {
        File file = new File(directory, STRINGS_PROPERTIES_FILE_NAME);
        try {
            return s_cache.getProperty(file, key);
        }
        catch (IOException e) {
            String message = "loadProperties: Error opening properties file " + file.getAbsolutePath() + ": " + e;
            LOG.warn(message, (Throwable)e);
            throw new DataAccessResourceFailureException(message, (Throwable)e);
        }
    }
}

