/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.common.utils;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.opennms.core.utils.InetAddressUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ReverseMap;

public class DnsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DnsUtils.class);
    public static final String DNS_PRIMARY_SERVER = "org.opennms.features.telemetry.dns.primaryServer";
    public static final String DNS_SECONDARY_SERVER = "org.opennms.features.telemetry.dns.secondaryServer";
    public static final String DNS_ENABLE = "org.opennms.features.telemetry.dns.enable";
    public static final String DNS_CACHE_COUNT = "org.opennms.features.telemetry.dns.cache.count";
    public static final String DNS_CACHE_MAX_TTL = "org.opennms.features.telemetry.dns.cache.maxttl";
    public static final int DNS_CACHE_COUNT_DEFAULT = 50000;
    private static ExtendedResolver resolver;
    private static Cache cache;
    private static String primaryServer;
    private static String secondaryServer;
    private static boolean enable;
    private static int cacheCount;
    private static int cacheMaxTTL;
    static BundleContext bundleContext;

    private static void checkSystemProperties() {
        if (bundleContext == null) {
            return;
        }
        String primaryServer = bundleContext.getProperty(DNS_PRIMARY_SERVER);
        String secondaryServer = bundleContext.getProperty(DNS_SECONDARY_SERVER);
        boolean enable = Boolean.parseBoolean(bundleContext.getProperty(DNS_ENABLE));
        if (enable != DnsUtils.enable || !Objects.equals(primaryServer, DnsUtils.primaryServer) || !Objects.equals(secondaryServer, DnsUtils.secondaryServer)) {
            DnsUtils.enable = enable;
            DnsUtils.primaryServer = primaryServer;
            DnsUtils.secondaryServer = secondaryServer;
            DnsUtils.setDnsServers(DnsUtils.primaryServer, DnsUtils.secondaryServer);
        }
        int cacheCount = Optional.ofNullable(bundleContext.getProperty(DNS_CACHE_COUNT)).map(Integer::parseInt).orElse(50000);
        int cacheMaxTTL = Optional.ofNullable(bundleContext.getProperty(DNS_CACHE_MAX_TTL)).map(Integer::parseInt).orElse(-1);
        if (cacheCount != DnsUtils.cacheCount || cacheMaxTTL != DnsUtils.cacheMaxTTL) {
            DnsUtils.cacheCount = cacheCount;
            DnsUtils.cacheMaxTTL = cacheMaxTTL;
            cache = new Cache();
            cache.setMaxEntries(DnsUtils.cacheCount);
            cache.setMaxCache(DnsUtils.cacheMaxTTL);
            cache.setMaxNCache(DnsUtils.cacheMaxTTL);
        }
    }

    public static synchronized void setDnsServers(String ... dnsServers) {
        String[] notNullDnsServers = dnsServers == null ? new String[]{} : (String[])Arrays.stream(dnsServers).filter(e -> !Strings.isNullOrEmpty((String)e)).toArray(String[]::new);
        try {
            resolver = notNullDnsServers.length == 0 ? new ExtendedResolver() : new ExtendedResolver(notNullDnsServers);
        }
        catch (UnknownHostException e2) {
            LOG.debug("Cannot create resolver for given servers {}: {}", (Object)dnsServers, (Object)e2.getMessage());
        }
    }

    static ExtendedResolver getResolver() {
        return resolver;
    }

    public static Optional<String> reverseLookup(String inetAddress) {
        return DnsUtils.reverseLookup(InetAddressUtils.addr((String)inetAddress));
    }

    public static Optional<String> reverseLookup(InetAddress inetAddress) {
        DnsUtils.checkSystemProperties();
        if (!enable) {
            return Optional.empty();
        }
        Lookup lookup = new Lookup(ReverseMap.fromAddress((InetAddress)inetAddress), 12);
        lookup.setResolver((Resolver)resolver);
        lookup.setCache(cache);
        Record[] records = lookup.run();
        if (lookup.getResult() == 0) {
            return Arrays.stream(records).filter(PTRRecord.class::isInstance).reduce((first, other) -> {
                LOG.warn("Reverse lookup of hostname got multiple results: {}", (Object)inetAddress);
                return first;
            }).map(rr -> ((PTRRecord)rr).getTarget().toString()).map(hostname -> hostname.substring(0, hostname.length() - 1));
        }
        LOG.warn("Reverse lookup of hostname failed: {}", (Object)inetAddress);
        return Optional.empty();
    }

    static {
        cache = new Cache();
        primaryServer = null;
        secondaryServer = null;
        enable = false;
        cacheCount = 50000;
        cacheMaxTTL = -1;
        try {
            resolver = new ExtendedResolver();
        }
        catch (UnknownHostException e) {
            LOG.debug("Cannot create resolver: {}", (Object)e.getMessage());
        }
        try {
            bundleContext = FrameworkUtil.getBundle(DnsUtils.class).getBundleContext();
        }
        catch (NullPointerException e) {
            LOG.debug("BundleContext not available: {}", (Object)e.getMessage());
        }
    }
}

