/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.shell;

import java.util.Objects;
import java.util.Optional;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.distributed.kvstore.api.KeyValueStore;

@Command(scope="kvstore", name="get", description="Get a record from the key value store")
@Service
public class KVStoreGet
implements Action {
    @Reference
    private KeyValueStore kvStore;
    @Argument(index=0, description="The key to look up")
    private String key;
    @Argument(index=1, description="The key's context")
    private String context;

    public Object execute() {
        Objects.requireNonNull(this.key);
        Objects.requireNonNull(this.context);
        Optional value = this.kvStore.get(this.key, this.context);
        if (value.isPresent()) {
            System.out.println(new String((byte[])value.get()));
        } else {
            System.out.println(String.format("Value for key '%s' could not be found", this.key));
        }
        return null;
    }
}

