/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.gson.annotations.SerializedName;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.elastic.Direction;
import org.opennms.netmgt.flows.elastic.Locality;
import org.opennms.netmgt.flows.elastic.NetflowVersion;
import org.opennms.netmgt.flows.elastic.NodeDocument;
import org.opennms.netmgt.flows.elastic.SamplingAlgorithm;

public class FlowDocument {
    private static final int DOCUMENT_VERSION = 1;
    @SerializedName(value="@timestamp")
    private long timestamp;
    @SerializedName(value="@version")
    private Integer version = 1;
    @SerializedName(value="host")
    private String host;
    @SerializedName(value="hosts")
    private Set<String> hosts = new LinkedHashSet<String>();
    @SerializedName(value="location")
    private String location;
    @SerializedName(value="netflow.application")
    private String application;
    @SerializedName(value="netflow.bytes")
    private Long bytes;
    @SerializedName(value="netflow.convo_key")
    private String convoKey;
    @SerializedName(value="netflow.direction")
    private Direction direction;
    @SerializedName(value="netflow.dst_addr")
    private String dstAddr;
    @SerializedName(value="netflow.dst_addr_hostname")
    private String dstAddrHostname;
    @SerializedName(value="netflow.dst_as")
    private Long dstAs;
    @SerializedName(value="netflow.dst_locality")
    private Locality dstLocality;
    @SerializedName(value="netflow.dst_mask_len")
    private Integer dstMaskLen;
    @SerializedName(value="netflow.dst_port")
    private Integer dstPort;
    @SerializedName(value="netflow.engine_id")
    private Integer engineId;
    @SerializedName(value="netflow.engine_type")
    private Integer engineType;
    @SerializedName(value="netflow.first_switched")
    private Long firstSwitched;
    @SerializedName(value="netflow.flow_locality")
    private Locality flowLocality;
    @SerializedName(value="netflow.flow_records")
    private int flowRecords;
    @SerializedName(value="netflow.flow_seq_num")
    private long flowSeqNum;
    @SerializedName(value="netflow.input_snmp")
    private Integer inputSnmp;
    @SerializedName(value="netflow.ip_protocol_version")
    private Integer ipProtocolVersion;
    @SerializedName(value="netflow.last_switched")
    private Long lastSwitched;
    @SerializedName(value="netflow.next_hop")
    private String nextHop;
    @SerializedName(value="netflow.next_hop_hostname")
    private String nextHopHostname;
    @SerializedName(value="netflow.output_snmp")
    private Integer outputSnmp;
    @SerializedName(value="netflow.packets")
    private Long packets;
    @SerializedName(value="netflow.protocol")
    private Integer protocol;
    @SerializedName(value="netflow.sampling_algorithm")
    private SamplingAlgorithm samplingAlgorithm;
    @SerializedName(value="netflow.sampling_interval")
    private Double samplingInterval;
    @SerializedName(value="netflow.src_addr")
    private String srcAddr;
    @SerializedName(value="netflow.src_addr_hostname")
    private String srcAddrHostname;
    @SerializedName(value="netflow.src_as")
    private Long srcAs;
    @SerializedName(value="netflow.src_locality")
    private Locality srcLocality;
    @SerializedName(value="netflow.src_mask_len")
    private Integer srcMaskLen;
    @SerializedName(value="netflow.src_port")
    private Integer srcPort;
    @SerializedName(value="netflow.tcp_flags")
    private Integer tcpFlags;
    @SerializedName(value="netflow.tos")
    private Integer tos;
    @SerializedName(value="netflow.version")
    private NetflowVersion netflowVersion;
    @SerializedName(value="netflow.vlan")
    private String vlan;
    @SerializedName(value="node_dst")
    private NodeDocument nodeDst;
    @SerializedName(value="node_exporter")
    private NodeDocument nodeExporter;
    @SerializedName(value="node_src")
    private NodeDocument nodeSrc;

    public void addHost(String host) {
        Objects.requireNonNull(host);
        this.hosts.add(host);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(Set<String> hosts) {
        this.hosts = hosts;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public Long getBytes() {
        return this.bytes;
    }

    public void setBytes(Long bytes) {
        this.bytes = bytes;
    }

    public String getConvoKey() {
        return this.convoKey;
    }

    public void setConvoKey(String convoKey) {
        this.convoKey = convoKey;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String getDstAddr() {
        return this.dstAddr;
    }

    public void setDstAddr(String dstAddr) {
        this.addHost(dstAddr);
        this.dstAddr = dstAddr;
    }

    public String getDstAddrHostname() {
        return this.dstAddrHostname;
    }

    public void setDstAddrHostname(String dstAddrHostname) {
        this.dstAddrHostname = dstAddrHostname;
    }

    public Long getDstAs() {
        return this.dstAs;
    }

    public void setDstAs(Long dstAs) {
        this.dstAs = dstAs;
    }

    public Locality getDstLocality() {
        return this.dstLocality;
    }

    public void setDstLocality(Locality dstLocality) {
        this.dstLocality = dstLocality;
    }

    public Integer getDstMaskLen() {
        return this.dstMaskLen;
    }

    public void setDstMaskLen(Integer dstMaskLen) {
        this.dstMaskLen = dstMaskLen;
    }

    public Integer getDstPort() {
        return this.dstPort;
    }

    public void setDstPort(Integer dstPort) {
        this.dstPort = dstPort;
    }

    public Integer getEngineId() {
        return this.engineId;
    }

    public void setEngineId(Integer engineId) {
        this.engineId = engineId;
    }

    public Integer getEngineType() {
        return this.engineType;
    }

    public void setEngineType(Integer engineType) {
        this.engineType = engineType;
    }

    public Long getFirstSwitched() {
        return this.firstSwitched;
    }

    public void setFirstSwitched(Long firstSwitched) {
        this.firstSwitched = firstSwitched;
    }

    public Locality getFlowLocality() {
        return this.flowLocality;
    }

    public void setFlowLocality(Locality flowLocality) {
        this.flowLocality = flowLocality;
    }

    public int getFlowRecords() {
        return this.flowRecords;
    }

    public void setFlowRecords(int flowRecords) {
        this.flowRecords = flowRecords;
    }

    public long getFlowSeqNum() {
        return this.flowSeqNum;
    }

    public void setFlowSeqNum(long flowSeqNum) {
        this.flowSeqNum = flowSeqNum;
    }

    public Integer getInputSnmp() {
        return this.inputSnmp;
    }

    public void setInputSnmp(Integer inputSnmp) {
        this.inputSnmp = inputSnmp;
    }

    public Integer getIpProtocolVersion() {
        return this.ipProtocolVersion;
    }

    public void setIpProtocolVersion(Integer ipProtocolVersion) {
        this.ipProtocolVersion = ipProtocolVersion;
    }

    public Long getLastSwitched() {
        return this.lastSwitched;
    }

    public void setLastSwitched(Long lastSwitched) {
        this.lastSwitched = lastSwitched;
    }

    public String getNextHop() {
        return this.nextHop;
    }

    public void setNextHop(String nextHop) {
        this.nextHop = nextHop;
    }

    public String getNextHopHostname() {
        return this.nextHopHostname;
    }

    public void setNextHopHostname(String nextHopHostname) {
        this.nextHopHostname = nextHopHostname;
    }

    public Integer getOutputSnmp() {
        return this.outputSnmp;
    }

    public void setOutputSnmp(Integer outputSnmp) {
        this.outputSnmp = outputSnmp;
    }

    public Long getPackets() {
        return this.packets;
    }

    public void setPackets(Long packets) {
        this.packets = packets;
    }

    public Integer getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    public SamplingAlgorithm getSamplingAlgorithm() {
        return this.samplingAlgorithm;
    }

    public void setSamplingAlgorithm(SamplingAlgorithm samplingAlgorithm) {
        this.samplingAlgorithm = samplingAlgorithm;
    }

    public Double getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setSamplingInterval(Double samplingInterval) {
        this.samplingInterval = samplingInterval;
    }

    public String getSrcAddr() {
        return this.srcAddr;
    }

    public void setSrcAddr(String srcAddr) {
        this.addHost(srcAddr);
        this.srcAddr = srcAddr;
    }

    public String getSrcAddrHostname() {
        return this.srcAddrHostname;
    }

    public void setSrcAddrHostname(String srcAddrHostname) {
        this.srcAddrHostname = srcAddrHostname;
    }

    public Long getSrcAs() {
        return this.srcAs;
    }

    public void setSrcAs(Long srcAs) {
        this.srcAs = srcAs;
    }

    public Locality getSrcLocality() {
        return this.srcLocality;
    }

    public void setSrcLocality(Locality srcLocality) {
        this.srcLocality = srcLocality;
    }

    public Integer getSrcMaskLen() {
        return this.srcMaskLen;
    }

    public void setSrcMaskLen(Integer srcMaskLen) {
        this.srcMaskLen = srcMaskLen;
    }

    public Integer getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(Integer srcPort) {
        this.srcPort = srcPort;
    }

    public Integer getTcpFlags() {
        return this.tcpFlags;
    }

    public void setTcpFlags(Integer tcpFlags) {
        this.tcpFlags = tcpFlags;
    }

    public Integer getTos() {
        return this.tos;
    }

    public void setTos(Integer tos) {
        this.tos = tos;
    }

    public NetflowVersion getNetflowVersion() {
        return this.netflowVersion;
    }

    public void setNetflowVersion(NetflowVersion netflowVersion) {
        this.netflowVersion = netflowVersion;
    }

    public String getVlan() {
        return this.vlan;
    }

    public void setVlan(String vlan) {
        this.vlan = vlan;
    }

    public NodeDocument getNodeDst() {
        return this.nodeDst;
    }

    public void setNodeDst(NodeDocument nodeDst) {
        this.nodeDst = nodeDst;
    }

    public NodeDocument getNodeExporter() {
        return this.nodeExporter;
    }

    public void setNodeExporter(NodeDocument nodeExporter) {
        this.nodeExporter = nodeExporter;
    }

    public NodeDocument getNodeSrc() {
        return this.nodeSrc;
    }

    public void setNodeSrc(NodeDocument nodeSrc) {
        this.nodeSrc = nodeSrc;
    }

    public static FlowDocument from(Flow flow) {
        FlowDocument doc = new FlowDocument();
        doc.setTimestamp(flow.getTimestamp());
        doc.setBytes(flow.getBytes());
        doc.setDirection(Direction.from(flow.getDirection()));
        doc.setDstAddr(flow.getDstAddr());
        flow.getDstAddrHostname().ifPresent(doc::setDstAddrHostname);
        doc.setDstAs(flow.getDstAs());
        doc.setDstMaskLen(flow.getDstMaskLen());
        doc.setDstPort(flow.getDstPort());
        doc.setEngineId(flow.getEngineId());
        doc.setEngineType(flow.getEngineType());
        doc.setFirstSwitched(flow.getFirstSwitched());
        doc.setFlowRecords(flow.getFlowRecords());
        doc.setFlowSeqNum(flow.getFlowSeqNum());
        doc.setInputSnmp(flow.getInputSnmp());
        doc.setIpProtocolVersion(flow.getIpProtocolVersion());
        doc.setLastSwitched(flow.getLastSwitched());
        doc.setNextHop(flow.getNextHop());
        flow.getNextHopHostname().ifPresent(doc::setNextHopHostname);
        doc.setOutputSnmp(flow.getOutputSnmp());
        doc.setPackets(flow.getPackets());
        doc.setProtocol(flow.getProtocol());
        doc.setSamplingAlgorithm(SamplingAlgorithm.from(flow.getSamplingAlgorithm()));
        doc.setSamplingInterval(flow.getSamplingInterval());
        doc.setSrcAddr(flow.getSrcAddr());
        flow.getSrcAddrHostname().ifPresent(doc::setSrcAddrHostname);
        doc.setSrcAs(flow.getSrcAs());
        doc.setSrcMaskLen(flow.getSrcMaskLen());
        doc.setSrcPort(flow.getSrcPort());
        doc.setTcpFlags(flow.getTcpFlags());
        doc.setTos(flow.getTos());
        doc.setNetflowVersion(NetflowVersion.from(flow.getNetflowVersion()));
        doc.setVlan(flow.getVlan() != null ? Integer.toUnsignedString(flow.getVlan()) : null);
        return doc;
    }
}

