/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import java.io.Closeable;
import java.util.NoSuchElementException;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;

public abstract class Pool<T>
implements Closeable {
    protected GenericObjectPool<T> internalPool;

    public Pool() {
    }

    public Pool(GenericObjectPoolConfig poolConfig, PooledObjectFactory<T> factory) {
        this.initPool(poolConfig, factory);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public boolean isClosed() {
        return this.internalPool.isClosed();
    }

    public void initPool(GenericObjectPoolConfig poolConfig, PooledObjectFactory<T> factory) {
        if (this.internalPool != null) {
            try {
                this.closeInternalPool();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.internalPool = new GenericObjectPool(factory, poolConfig);
    }

    public T getResource() {
        try {
            return (T)this.internalPool.borrowObject();
        }
        catch (NoSuchElementException nse) {
            throw new JedisException("Could not get a resource from the pool", nse);
        }
        catch (Exception e) {
            throw new JedisConnectionException("Could not get a resource from the pool", e);
        }
    }

    @Deprecated
    public void returnResourceObject(T resource) {
        if (resource == null) {
            return;
        }
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            throw new JedisException("Could not return the resource to the pool", e);
        }
    }

    @Deprecated
    public void returnBrokenResource(T resource) {
        if (resource != null) {
            this.returnBrokenResourceObject(resource);
        }
    }

    @Deprecated
    public void returnResource(T resource) {
        if (resource != null) {
            this.returnResourceObject(resource);
        }
    }

    public void destroy() {
        this.closeInternalPool();
    }

    protected void returnBrokenResourceObject(T resource) {
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            throw new JedisException("Could not return the resource to the pool", e);
        }
    }

    protected void closeInternalPool() {
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new JedisException("Could not destroy the pool", e);
        }
    }

    public int getNumActive() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumActive();
    }

    public int getNumIdle() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumIdle();
    }

    public int getNumWaiters() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumWaiters();
    }

    public long getMeanBorrowWaitTimeMillis() {
        if (this.poolInactive()) {
            return -1L;
        }
        return this.internalPool.getMeanBorrowWaitTimeMillis();
    }

    public long getMaxBorrowWaitTimeMillis() {
        if (this.poolInactive()) {
            return -1L;
        }
        return this.internalPool.getMaxBorrowWaitTimeMillis();
    }

    private boolean poolInactive() {
        return this.internalPool == null || this.internalPool.isClosed();
    }

    public void addObjects(int count) {
        try {
            for (int i = 0; i < count; ++i) {
                this.internalPool.addObject();
            }
        }
        catch (Exception e) {
            throw new JedisException("Error trying to add idle objects", e);
        }
    }
}

