/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyConsumer;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyMessage;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyUpdater;

public class OnmsTopologyDaoInMemoryImpl
implements OnmsTopologyDao {
    private final Map<OnmsTopologyProtocol, OnmsTopologyUpdater> m_updatersMap = new HashMap<OnmsTopologyProtocol, OnmsTopologyUpdater>();
    final Set<OnmsTopologyConsumer> m_consumers = new HashSet<OnmsTopologyConsumer>();

    @Override
    public OnmsTopology getTopology(String protocolSupported) {
        OnmsTopologyProtocol protocol = OnmsTopologyProtocol.create(protocolSupported);
        if (this.m_updatersMap.containsKey(protocol)) {
            return this.m_updatersMap.get(protocol).getTopology();
        }
        throw new IllegalArgumentException(String.format("%s protocol not supported", protocolSupported));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(OnmsTopologyConsumer consumer) {
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            this.m_consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(OnmsTopologyConsumer consumer) {
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            this.m_consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(OnmsTopologyUpdater updater) {
        Map<OnmsTopologyProtocol, OnmsTopologyUpdater> map = this.m_updatersMap;
        synchronized (map) {
            if (this.m_updatersMap.containsKey(updater.getProtocol())) {
                throw new IllegalArgumentException("Protocol already registered " + updater.getProtocol());
            }
            this.m_updatersMap.put(updater.getProtocol(), updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(OnmsTopologyUpdater updater) {
        Map<OnmsTopologyProtocol, OnmsTopologyUpdater> map = this.m_updatersMap;
        synchronized (map) {
            OnmsTopologyUpdater subscribed = this.m_updatersMap.get(updater.getProtocol());
            if (subscribed == null || subscribed != updater) {
                throw new IllegalArgumentException("updater is not registered " + updater.getProtocol());
            }
            this.m_updatersMap.remove(updater.getProtocol());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getSupportedProtocols() {
        HashSet<String> protocols = new HashSet<String>();
        Map<OnmsTopologyProtocol, OnmsTopologyUpdater> map = this.m_updatersMap;
        synchronized (map) {
            this.m_updatersMap.keySet().stream().forEach(p -> protocols.add(p.getId()));
        }
        return protocols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(OnmsTopologyUpdater updater, OnmsTopologyMessage message) {
        OnmsTopologyProtocol protocol = updater.getProtocol();
        if (!this.m_updatersMap.containsKey(protocol)) {
            throw new IllegalArgumentException(String.format("cannot update message with id: %s. Protocol %s not supported for message status %s", new Object[]{message.getMessagebody().getId(), protocol, message.getMessagestatus()}));
        }
        if (this.m_updatersMap.get(protocol) != updater) {
            throw new IllegalArgumentException(String.format("cannot update message with id: %s, protocol: %s and message status: %s. Updater not registered", new Object[]{message.getMessagebody().getId(), protocol, message.getMessagestatus()}));
        }
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            this.m_consumers.stream().filter(consumer -> {
                if (consumer.getProtocols() == null) {
                    return false;
                }
                return consumer.getProtocols().contains(protocol);
            }).forEach(consumer -> consumer.consume(message));
        }
    }
}

