/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.coordination.zookeeper;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.opennms.features.distributed.coordination.api.DomainManager;
import org.opennms.features.distributed.coordination.common.AbstractDomainManagerFactory;
import org.opennms.features.distributed.coordination.zookeeper.ZookeeperDomainManager;

public class ZookeeperDomainManagerFactory
extends AbstractDomainManagerFactory {
    private final String connectString;
    private final String namespace;

    public ZookeeperDomainManagerFactory(String connectString, String namespace) {
        this.connectString = connectString;
        this.namespace = namespace;
    }

    protected DomainManager createManagerForDomain(String domain) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.connectString).namespace(this.namespace).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        return ZookeeperDomainManager.of(domain, builder);
    }

    public String toString() {
        return "ZookeeperDomainManagerFactory{} " + super.toString();
    }
}

