/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.internal.matcher.Matcher;
import org.opennms.netmgt.flows.classification.internal.value.StringValue;
import org.opennms.netmgt.flows.classification.persistence.api.Protocol;
import org.opennms.netmgt.flows.classification.persistence.api.Protocols;

public class ProtocolMatcher
implements Matcher {
    private final List<Protocol> protocols = new ArrayList<Protocol>();

    public ProtocolMatcher(String protocols) {
        StringValue stringValue = new StringValue(protocols);
        this.protocols.addAll(stringValue.splitBy(",").stream().map(p -> Protocols.getProtocol((String)p.getValue())).filter(p -> p != null).collect(Collectors.toList()));
    }

    public ProtocolMatcher(int protocol) {
        this(Protocols.getProtocol((int)protocol));
    }

    public ProtocolMatcher(Protocol protocol) {
        this.protocols.add(Objects.requireNonNull(protocol));
    }

    @Override
    public boolean matches(ClassificationRequest request) {
        return this.protocols.stream().filter(p -> p.getDecimal() == request.getProtocol().getDecimal()).findAny().isPresent();
    }
}

