/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.TopologyProtocol;
import org.opennms.integration.api.v1.model.TopologySegment;

public final class ImmutableTopologySegment
implements TopologySegment {
    private final String id;
    private final TopologyProtocol protocol;
    private final String tooltipText;

    private ImmutableTopologySegment(Builder builder) {
        this.id = builder.id;
        this.tooltipText = builder.tooltipText;
        this.protocol = builder.protocol;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public TopologyProtocol getProtocol() {
        return this.protocol;
    }

    public String getSegmentCriteria() {
        return String.format("%s:%s", this.protocol, this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTopologySegment that = (ImmutableTopologySegment)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.tooltipText, that.tooltipText);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.protocol, this.tooltipText);
    }

    public String toString() {
        return "ImmutableTopologySegment{id='" + this.id + '\'' + ", protocol='" + this.protocol + '\'' + ", tooltipText='" + this.tooltipText + '\'' + '}';
    }

    public static class Builder {
        private String id;
        private String tooltipText;
        private TopologyProtocol protocol;

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        public Builder setProtocol(TopologyProtocol protocol) {
            this.protocol = Objects.requireNonNull(protocol);
            return this;
        }

        public Builder setTooltipText(String tooltipText) {
            this.tooltipText = tooltipText;
            return this;
        }

        public ImmutableTopologySegment build() {
            Objects.requireNonNull(this.id);
            Objects.requireNonNull(this.protocol);
            return new ImmutableTopologySegment(this);
        }
    }
}

