/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.TopologyEdge;
import org.opennms.integration.api.v1.model.TopologyPort;
import org.opennms.integration.api.v1.model.TopologyProtocol;
import org.opennms.integration.api.v1.model.TopologySegment;

public final class ImmutableTopologyEdge
implements TopologyEdge {
    private final TopologyProtocol protocol;
    private final String id;
    private final String tooltipText;
    private final TopologyPort source;
    private final TopologyPort targetPort;
    private final TopologySegment targetSegment;

    private ImmutableTopologyEdge(Builder builder) {
        this.protocol = builder.protocol;
        this.id = builder.id;
        this.tooltipText = builder.tooltipText;
        this.source = builder.source;
        this.targetPort = builder.targetPort;
        this.targetSegment = builder.targetSegment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public TopologyProtocol getProtocol() {
        return this.protocol;
    }

    public String getId() {
        return this.id;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public TopologyPort getSource() {
        return this.source;
    }

    public void visitTarget(TopologyEdge.TopologyEdgeTargetVisitor v) {
        if (this.targetPort != null) {
            v.visitTargetPort(this.targetPort);
        } else {
            v.visitTargetSegement(this.targetSegment);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTopologyEdge that = (ImmutableTopologyEdge)o;
        return Objects.equals(this.protocol, that.protocol) && Objects.equals(this.id, that.id) && Objects.equals(this.tooltipText, that.tooltipText) && Objects.equals(this.source, that.source) && Objects.equals(this.targetPort, that.targetPort) && Objects.equals(this.targetSegment, that.targetSegment);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.id, this.tooltipText, this.source, this.targetPort, this.targetSegment);
    }

    public String toString() {
        return "ImmutableTopologyEdge{protocol='" + this.protocol + '\'' + ", id='" + this.id + '\'' + ", tooltipText='" + this.tooltipText + '\'' + ", source=" + this.source + ", targetPort=" + this.targetPort + ", targetSegment=" + this.targetSegment + '}';
    }

    public static class Builder {
        private TopologyProtocol protocol;
        private String id;
        private String tooltipText;
        private TopologyPort source;
        private TopologyPort targetPort;
        private TopologySegment targetSegment;

        private Builder() {
        }

        public Builder setProtocol(TopologyProtocol protocol) {
            this.protocol = Objects.requireNonNull(protocol);
            return this;
        }

        public Builder setId(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        public Builder setTooltipText(String tooltipText) {
            this.tooltipText = tooltipText;
            return this;
        }

        public Builder setSource(TopologyPort source) {
            this.source = Objects.requireNonNull(source);
            return this;
        }

        public Builder setTargetPort(TopologyPort targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        public Builder setTargetSegment(TopologySegment targetSegment) {
            this.targetSegment = targetSegment;
            return this;
        }

        public ImmutableTopologyEdge build() {
            Objects.requireNonNull(this.id);
            Objects.requireNonNull(this.protocol);
            if (this.targetPort == null && this.targetSegment == null) {
                throw new NullPointerException("Edge must have a target");
            }
            if (this.targetPort != null && this.targetSegment != null) {
                throw new IllegalStateException("Edge cannot have both a target port and a target segment");
            }
            return new ImmutableTopologyEdge(this);
        }
    }
}

