/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.requisition.beans;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.config.requisition.RequisitionAsset;
import org.opennms.integration.api.v1.config.requisition.RequisitionInterface;
import org.opennms.integration.api.v1.config.requisition.RequisitionMetaData;
import org.opennms.integration.api.v1.config.requisition.RequisitionNode;
import org.opennms.integration.api.v1.config.requisition.beans.RequisitionAssetBean;
import org.opennms.integration.api.v1.config.requisition.beans.RequisitionMetaDataBean;

public class RequisitionNodeBean
implements RequisitionNode {
    private final String foreignId;
    private final String nodeLabel;
    private final String location;
    private final List<RequisitionInterface> interfaces;
    private final List<String> categories;
    private final List<RequisitionAsset> assets;
    private final List<RequisitionMetaData> metaData;

    private RequisitionNodeBean(Builder builder) {
        this.foreignId = builder.foreignId;
        this.nodeLabel = builder.nodeLabel;
        this.location = builder.location;
        this.interfaces = Collections.unmodifiableList(builder.interfaces != null ? builder.interfaces : Collections.emptyList());
        this.categories = Collections.unmodifiableList(builder.categories != null ? builder.categories : Collections.emptyList());
        this.assets = Collections.unmodifiableList(builder.assets != null ? builder.assets : Collections.emptyList());
        this.metaData = Collections.unmodifiableList(builder.metaData != null ? builder.metaData : Collections.emptyList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLocation() {
        return this.location;
    }

    public List<RequisitionInterface> getInterfaces() {
        return this.interfaces;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<RequisitionAsset> getAssets() {
        return this.assets;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public List<RequisitionMetaData> getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequisitionNodeBean that = (RequisitionNodeBean)o;
        return Objects.equals(this.foreignId, that.foreignId) && Objects.equals(this.nodeLabel, that.nodeLabel) && Objects.equals(this.location, that.location) && Objects.equals(this.interfaces, that.interfaces) && Objects.equals(this.categories, that.categories) && Objects.equals(this.assets, that.assets) && Objects.equals(this.metaData, that.metaData);
    }

    public int hashCode() {
        return Objects.hash(this.foreignId, this.nodeLabel, this.location, this.interfaces, this.categories, this.assets, this.metaData);
    }

    public String toString() {
        return "RequisitionNodeBean{foreignId='" + this.foreignId + '\'' + ", nodeLabel='" + this.nodeLabel + '\'' + ", location='" + this.location + '\'' + ", interfaces=" + this.interfaces + ", categories=" + this.categories + ", assets=" + this.assets + ", metaData=" + this.metaData + '}';
    }

    public static class Builder {
        private String foreignId;
        private String nodeLabel;
        private String location;
        private List<RequisitionInterface> interfaces = new LinkedList<RequisitionInterface>();
        private List<String> categories = new LinkedList<String>();
        private List<RequisitionAsset> assets = new LinkedList<RequisitionAsset>();
        private List<RequisitionMetaData> metaData = new LinkedList<RequisitionMetaData>();

        public Builder foreignId(String foreignId) {
            this.foreignId = foreignId;
            return this;
        }

        public Builder nodeLabel(String nodeLabel) {
            this.nodeLabel = nodeLabel;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder interfaces(List<RequisitionInterface> interfaces) {
            this.interfaces = interfaces;
            return this;
        }

        public Builder iface(RequisitionInterface iface) {
            this.interfaces.add(iface);
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            return this;
        }

        public Builder category(String category) {
            this.categories.add(category);
            return this;
        }

        public Builder assets(List<RequisitionAsset> assets) {
            this.assets = assets;
            return this;
        }

        public Builder asset(RequisitionAsset asset) {
            this.assets.add(asset);
            return this;
        }

        public Builder asset(String name, String value) {
            this.assets.add(RequisitionAssetBean.builder().name(name).value(value).build());
            return this;
        }

        public Builder metaData(List<RequisitionMetaData> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder metaData(String context, String key, String value) {
            this.metaData.add(RequisitionMetaDataBean.builder().context(context).key(key).value(value).build());
            return this;
        }

        public RequisitionNodeBean build() {
            Objects.requireNonNull(this.foreignId, "foreignId is required");
            return new RequisitionNodeBean(this);
        }
    }
}

