/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.requisition.beans;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.config.requisition.RequisitionMetaData;
import org.opennms.integration.api.v1.config.requisition.RequisitionMonitoredService;
import org.opennms.integration.api.v1.config.requisition.beans.RequisitionMetaDataBean;

public class RequisitionMonitoredServiceBean
implements RequisitionMonitoredService {
    private final String name;
    private final List<RequisitionMetaData> metaData;

    private RequisitionMonitoredServiceBean(Builder builder) {
        this.name = builder.name;
        this.metaData = Collections.unmodifiableList(builder.metaData != null ? builder.metaData : Collections.emptyList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public List<RequisitionMetaData> getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequisitionMonitoredServiceBean that = (RequisitionMonitoredServiceBean)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.metaData, that.metaData);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.metaData);
    }

    public String toString() {
        return "RequisitionMonitoredServiceBean{name=" + this.name + ", metaData=" + this.metaData + '}';
    }

    public static class Builder {
        private String name;
        private List<RequisitionMetaData> metaData = new LinkedList<RequisitionMetaData>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder metaData(List<RequisitionMetaData> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder metaData(String context, String key, String value) {
            this.metaData.add(RequisitionMetaDataBean.builder().context(context).key(key).value(value).build());
            return this;
        }

        public RequisitionMonitoredServiceBean build() {
            Objects.requireNonNull(this.name, "name is required");
            return new RequisitionMonitoredServiceBean(this);
        }
    }
}

