/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.requisition.beans;

import java.net.InetAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.config.requisition.RequisitionInterface;
import org.opennms.integration.api.v1.config.requisition.RequisitionMetaData;
import org.opennms.integration.api.v1.config.requisition.RequisitionMonitoredService;
import org.opennms.integration.api.v1.config.requisition.SnmpPrimaryType;
import org.opennms.integration.api.v1.config.requisition.beans.RequisitionMetaDataBean;
import org.opennms.integration.api.v1.config.requisition.beans.RequisitionMonitoredServiceBean;

public class RequisitionInterfaceBean
implements RequisitionInterface {
    private final InetAddress ipAddress;
    private final SnmpPrimaryType snmpPrimary;
    private final String description;
    private final List<RequisitionMonitoredService> monitoredServices;
    private final List<RequisitionMetaData> metaData;

    private RequisitionInterfaceBean(Builder builder) {
        this.ipAddress = builder.ipAddress;
        this.snmpPrimary = builder.snmpPrimary;
        this.description = builder.description;
        this.monitoredServices = Collections.unmodifiableList(builder.monitoredServices != null ? builder.monitoredServices : Collections.emptyList());
        this.metaData = Collections.unmodifiableList(builder.metaData != null ? builder.metaData : Collections.emptyList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<RequisitionMonitoredService> getMonitoredServices() {
        return this.monitoredServices;
    }

    public String getDescription() {
        return this.description;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public SnmpPrimaryType getSnmpPrimary() {
        return this.snmpPrimary;
    }

    public List<RequisitionMetaData> getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequisitionInterfaceBean that = (RequisitionInterfaceBean)o;
        return Objects.equals(this.ipAddress, that.ipAddress) && this.snmpPrimary == that.snmpPrimary && Objects.equals(this.description, that.description) && Objects.equals(this.monitoredServices, that.monitoredServices) && Objects.equals(this.metaData, that.metaData);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.snmpPrimary, this.description, this.monitoredServices, this.metaData);
    }

    public String toString() {
        return "RequisitionInterfaceBean{ipAddress=" + this.ipAddress + ", snmpPrimary=" + this.snmpPrimary + ", description='" + this.description + '\'' + ", monitoredServices=" + this.monitoredServices + ", metaData=" + this.metaData + '}';
    }

    public static class Builder {
        private InetAddress ipAddress;
        private SnmpPrimaryType snmpPrimary;
        private String description;
        private List<RequisitionMonitoredService> monitoredServices = new LinkedList<RequisitionMonitoredService>();
        private List<RequisitionMetaData> metaData = new LinkedList<RequisitionMetaData>();

        public Builder ipAddress(InetAddress ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder snmpPrimary(SnmpPrimaryType snmpPrimary) {
            this.snmpPrimary = snmpPrimary;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder monitoredServices(List<RequisitionMonitoredService> monitoredServices) {
            this.monitoredServices = monitoredServices;
            return this;
        }

        public Builder monitoredService(RequisitionMonitoredService monitoredService) {
            this.monitoredServices.add(monitoredService);
            return this;
        }

        public Builder monitoredService(String name) {
            this.monitoredServices.add(RequisitionMonitoredServiceBean.builder().name(name).build());
            return this;
        }

        public Builder metaData(List<RequisitionMetaData> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder metaData(String context, String key, String value) {
            this.metaData.add(RequisitionMetaDataBean.builder().context(context).key(key).value(value).build());
            return this;
        }

        public RequisitionInterfaceBean build() {
            Objects.requireNonNull(this.ipAddress, "ipAddress is required");
            return new RequisitionInterfaceBean(this);
        }
    }
}

