/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.collectors.RrdRepository;

public class RrdRepositoryBean
implements RrdRepository {
    private final int step;
    private final int heartbeat;
    private final List<String> rras;

    public static Builder builder() {
        return new Builder();
    }

    private RrdRepositoryBean(Builder builder) {
        this.step = builder.step;
        this.heartbeat = builder.heartbeat;
        this.rras = Collections.unmodifiableList(builder.rras);
    }

    public int getStep() {
        return this.step;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public List<String> getRRAs() {
        return this.rras;
    }

    public static class Builder {
        private Integer step;
        private Integer heartbeat;
        private List<String> rras = new ArrayList<String>();

        public Builder withStep(int step) {
            if (step <= 0) {
                throw new IllegalArgumentException("step must be strictly positive ( >0 )");
            }
            this.step = step;
            return this;
        }

        public Builder withHeartbeat(int heartbeat) {
            if (heartbeat <= 0) {
                throw new IllegalArgumentException("heartbeat must be strictly positive ( >0 )");
            }
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder withRRAs(List<String> rras) {
            this.rras = Objects.requireNonNull(rras);
            return this;
        }

        public Builder withRRA(String rra) {
            this.rras.add(rra);
            return this;
        }

        public RrdRepositoryBean build() {
            Objects.requireNonNull(this.step, "step is required");
            Objects.requireNonNull(this.heartbeat, "heartbeat is required");
            if (this.rras.isEmpty()) {
                throw new IllegalArgumentException("One or more RRAs are required.");
            }
            return new RrdRepositoryBean(this);
        }
    }
}

