/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.eventconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.opennms.integration.api.xml.schema.eventconf.Event;
import org.opennms.integration.api.xml.schema.eventconf.EventOrdering;
import org.opennms.integration.api.xml.schema.eventconf.Global;

@XmlRootElement(name="events")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={})
public class Events
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="global", required=false)
    private Global m_global;
    @XmlElement(name="event", required=false)
    private List<Event> m_events = new ArrayList<Event>();
    @XmlElement(name="event-file", required=false)
    private List<String> m_eventFiles = new ArrayList<String>();
    @XmlTransient
    private Map<String, Events> m_loadedEventFiles = new LinkedHashMap<String, Events>();
    @XmlTransient
    private Map<String, List<Event>> m_partitionedEvents;
    @XmlTransient
    private List<Event> m_nullPartitionedEvents;
    @XmlTransient
    private Map<String, Event> m_eventsByUei = new HashMap<String, Event>();
    @XmlTransient
    private List<Event> m_wildcardEvents;
    @XmlTransient
    private EventOrdering m_ordering;

    public Global getGlobal() {
        return this.m_global;
    }

    public void setGlobal(Global global) {
        this.m_global = global;
    }

    public List<Event> getEvents() {
        return this.m_events;
    }

    public void setEvents(List<Event> events) {
        if (this.m_events == events) {
            return;
        }
        this.m_events.clear();
        if (events != null) {
            this.m_events.addAll(events);
        }
    }

    public void addEvent(Event event) {
        this.m_events.add(event);
    }

    public boolean removeEvent(Event event) {
        return this.m_events.remove(event);
    }

    public List<String> getEventFiles() {
        return this.m_eventFiles;
    }

    public int hashCode() {
        return Objects.hash(this.m_global, this.m_events, this.m_eventFiles);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Events) {
            Events that = (Events)obj;
            return Objects.equals(this.m_global, that.m_global) && Objects.equals(this.m_events, that.m_events) && Objects.equals(this.m_eventFiles, that.m_eventFiles);
        }
        return false;
    }

    private void forEachEvent(Consumer<Event> callback) {
        this.forEachEvent(callback, this, null);
    }

    private void forEachEvent(Consumer<Event> callback, Events eventFile, Set<String> filesProcessed) {
        for (Event event : eventFile.m_events) {
            callback.accept(event);
        }
        if (filesProcessed == null) {
            filesProcessed = new HashSet<String>();
        }
        for (Map.Entry entry : this.m_loadedEventFiles.entrySet()) {
            if (filesProcessed.contains(entry.getKey())) continue;
            filesProcessed.add((String)entry.getKey());
            this.forEachEvent(callback, (Events)entry.getValue(), filesProcessed);
        }
    }

    public static interface EventCriteria {
        public boolean matches(Event var1);
    }

    public static interface EventCallback<T> {
        public T process(T var1, Event var2);
    }
}

