/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.jti.adapter;

import com.google.protobuf.Extension;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.protocols.jti.adapter.proto.Port;
import org.opennms.netmgt.telemetry.protocols.jti.adapter.proto.TelemetryTop;

public class JtiClient {
    private static TelemetryTop.TelemetryStream buildJtiMessage(String ipAddress, String ifName, long ifInOctets, long ifOutOctets) {
        Port.GPort port = Port.GPort.newBuilder().addInterfaceStats(Port.InterfaceInfos.newBuilder().setIfName(ifName).setInitTime(1457647123L).setSnmpIfIndex(517).setParentAeName("ae0").setIngressStats(Port.InterfaceStats.newBuilder().setIfOctets(ifInOctets).setIfPkts(1L).setIf1SecPkts(1L).setIf1SecOctets(1L).setIfUcPkts(1L).setIfMcPkts(1L).setIfBcPkts(1L).build()).setEgressStats(Port.InterfaceStats.newBuilder().setIfOctets(ifOutOctets).setIfPkts(1L).setIf1SecPkts(1L).setIf1SecOctets(1L).setIfUcPkts(1L).setIfMcPkts(1L).setIfBcPkts(1L).build()).build()).build();
        TelemetryTop.JuniperNetworksSensors juniperNetworksSensors = ((TelemetryTop.JuniperNetworksSensors.Builder)TelemetryTop.JuniperNetworksSensors.newBuilder().setExtension((Extension)Port.jnprInterfaceExt, port)).build();
        TelemetryTop.EnterpriseSensors sensors = ((TelemetryTop.EnterpriseSensors.Builder)TelemetryTop.EnterpriseSensors.newBuilder().setExtension((Extension)TelemetryTop.juniperNetworks, juniperNetworksSensors)).build();
        TelemetryTop.TelemetryStream jtiMsg = TelemetryTop.TelemetryStream.newBuilder().setSystemId(ipAddress).setComponentId(0).setSensorName("intf-stats").setSequenceNumber(49103).setTimestamp(new Date().getTime()).setEnterprise(sensors).build();
        return jtiMsg;
    }

    public static void main(String ... args) throws IOException {
        TelemetryTop.TelemetryStream jtiMsg = JtiClient.buildJtiMessage("192.168.2.1", "eth0", 100L, 100L);
        byte[] jtiMsgBytes = jtiMsg.toByteArray();
        InetAddress address = InetAddressUtils.getLocalHostAddress();
        DatagramPacket packet = new DatagramPacket(jtiMsgBytes, jtiMsgBytes.length, address, 50000);
        DatagramSocket socket = new DatagramSocket();
        socket.send(packet);
    }
}

