/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.resource;

import java.util.Objects;
import org.opennms.integration.api.v1.collectors.resource.NumericAttribute;
import org.opennms.integration.api.v1.collectors.resource.StringAttribute;

public class AttributeBuilder {
    private String name;
    private String group;
    private String stringValue;
    private Double numericValue;
    private NumericAttribute.Type type;

    public AttributeBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public AttributeBuilder withGroup(String group) {
        this.group = group;
        return this;
    }

    public AttributeBuilder withStringValue(String value) {
        this.stringValue = value;
        return this;
    }

    public AttributeBuilder withNumericValue(double value) {
        this.numericValue = value;
        return this;
    }

    public AttributeBuilder withType(NumericAttribute.Type type) {
        this.type = type;
        return this;
    }

    public NumericAttribute buildNumeric() {
        Objects.requireNonNull(this.name, "name is required");
        Objects.requireNonNull(this.group, "group is required");
        Objects.requireNonNull(this.type, "type is required");
        Objects.requireNonNull(this.numericValue, "numericValue is required");
        return new NumericAttribute(){

            @Override
            public String getName() {
                return AttributeBuilder.this.name;
            }

            @Override
            public String getGroup() {
                return AttributeBuilder.this.group;
            }

            @Override
            public NumericAttribute.Type getType() {
                return AttributeBuilder.this.type;
            }

            @Override
            public double getValue() {
                return AttributeBuilder.this.numericValue;
            }
        };
    }

    public StringAttribute buildString() {
        Objects.requireNonNull(this.name, "name is required");
        Objects.requireNonNull(this.stringValue, "stringValue is required");
        return new StringAttribute(){

            @Override
            public String getName() {
                return AttributeBuilder.this.name;
            }

            @Override
            public String getValue() {
                return AttributeBuilder.this.stringValue;
            }

            @Override
            public String getGroup() {
                return AttributeBuilder.this.group;
            }
        };
    }
}

