/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.opennms.netmgt.dao.api.AlarmEntityListener;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsMemo;
import org.opennms.netmgt.model.OnmsReductionKeyMemo;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmEntityNotifierImpl
implements AlarmEntityNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmEntityNotifierImpl.class);
    private Set<AlarmEntityListener> listeners = Sets.newConcurrentHashSet();

    @Override
    public void didCreateAlarm(OnmsAlarm alarm) {
        this.forEachListener(l -> l.onAlarmCreated(alarm));
    }

    @Override
    public void didUpdateAlarmWithReducedEvent(OnmsAlarm alarm) {
        this.forEachListener(l -> l.onAlarmUpdatedWithReducedEvent(alarm));
    }

    @Override
    public void didAcknowledgeAlarm(OnmsAlarm alarm, String previousAckUser, Date previousAckTime) {
        this.forEachListener(l -> l.onAlarmAcknowledged(alarm, previousAckUser, previousAckTime));
    }

    @Override
    public void didUnacknowledgeAlarm(OnmsAlarm alarm, String previousAckUser, Date previousAckTime) {
        this.forEachListener(l -> l.onAlarmUnacknowledged(alarm, previousAckUser, previousAckTime));
    }

    @Override
    public void didUpdateAlarmSeverity(OnmsAlarm alarm, OnmsSeverity previousSeverity) {
        this.forEachListener(l -> l.onAlarmSeverityUpdated(alarm, previousSeverity));
    }

    @Override
    public void didArchiveAlarm(OnmsAlarm alarm, String previousReductionKey) {
        this.forEachListener(l -> l.onAlarmArchived(alarm, previousReductionKey));
    }

    @Override
    public void didDeleteAlarm(OnmsAlarm alarm) {
        this.forEachListener(l -> l.onAlarmDeleted(alarm));
    }

    @Override
    public void didUpdateStickyMemo(OnmsAlarm alarm, String previousBody, String previousAuthor, Date previousUpdated) {
        this.forEachListener(l -> l.onStickyMemoUpdated(alarm, previousBody, previousAuthor, previousUpdated));
    }

    @Override
    public void didUpdateReductionKeyMemo(OnmsAlarm alarm, String previousBody, String previousAuthor, Date previousUpdated) {
        this.forEachListener(l -> l.onReductionKeyMemoUpdated(alarm, previousBody, previousAuthor, previousUpdated));
    }

    @Override
    public void didDeleteStickyMemo(OnmsAlarm alarm, OnmsMemo memo) {
        this.forEachListener(l -> l.onStickyMemoDeleted(alarm, memo));
    }

    @Override
    public void didDeleteReductionKeyMemo(OnmsAlarm alarm, OnmsReductionKeyMemo memo) {
        this.forEachListener(l -> l.onReductionKeyMemoDeleted(alarm, memo));
    }

    @Override
    public void didUpdateLastAutomationTime(OnmsAlarm alarm, Date previousLastAutomationTime) {
        this.forEachListener(l -> l.onLastAutomationTimeUpdated(alarm, previousLastAutomationTime));
    }

    @Override
    public void didUpdateRelatedAlarms(OnmsAlarm alarm, Set<OnmsAlarm> previousRelatedAlarms) {
        this.forEachListener(l -> l.onRelatedAlarmsUpdated(alarm, previousRelatedAlarms));
    }

    private void forEachListener(Consumer<AlarmEntityListener> callback) {
        for (AlarmEntityListener listener : this.listeners) {
            try {
                callback.accept(listener);
            }
            catch (Exception e) {
                LOG.error("Error occurred while invoking listener: {}. Skipping.", (Object)listener, (Object)e);
            }
        }
    }

    public void onListenerRegistered(AlarmEntityListener listener, Map<String, String> properties) {
        LOG.debug("onListenerRegistered: {} with properties: {}", (Object)listener, properties);
        this.listeners.add(listener);
    }

    public void onListenerUnregistered(AlarmEntityListener listener, Map<String, String> properties) {
        LOG.debug("onListenerUnregistered: {} with properties: {}", (Object)listener, properties);
        this.listeners.remove(listener);
    }
}

