/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.opennms.integration.api.v1.config.datacollection.graphs.PrefabGraph;
import org.opennms.integration.api.v1.config.datacollection.graphs.PrefabGraphBuilder;
import org.opennms.integration.api.xml.ClassPathGraphPropertiesLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphPropertiesParser {
    public static final String DEFAULT_GRAPH_LIST_KEY = "reports";
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathGraphPropertiesLoader.class);

    public static List<PrefabGraph> loadPreFabGraphsFromInputStream(InputStream inputStream) throws IOException {
        String[] list;
        ArrayList<PrefabGraph> graphs = new ArrayList<PrefabGraph>();
        Properties properties = new Properties();
        properties.load(inputStream);
        String listString = properties.getProperty(DEFAULT_GRAPH_LIST_KEY);
        if (listString != null) {
            list = GraphPropertiesParser.parseBundleList(listString);
        } else {
            list = new String[]{properties.getProperty("report.id")};
            if (list[0] == null) {
                return graphs;
            }
        }
        for (String name : list) {
            try {
                PrefabGraph graph = GraphPropertiesParser.makePrefabGraph(name, properties);
                graphs.add(graph);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Failed to load report '{}'", (Object)name, (Object)e);
            }
        }
        return graphs;
    }

    public static PrefabGraph makePrefabGraph(String name, Properties props) {
        String typesString;
        String propertiesValuesString;
        PrefabGraphBuilder builder = new PrefabGraphBuilder();
        String key = name;
        builder.withName(name);
        if (props.getProperty("report.id") != null) {
            key = null;
        }
        builder.withTitle(GraphPropertiesParser.getReportProperty(props, key, "name", true));
        builder.withCommand(GraphPropertiesParser.getReportProperty(props, key, "command", true));
        String columnString = GraphPropertiesParser.getReportProperty(props, key, "columns", true);
        builder.withColumns(GraphPropertiesParser.parseBundleList(columnString));
        String externalValuesString = GraphPropertiesParser.getReportProperty(props, key, "externalValues", false);
        if (externalValuesString != null) {
            builder.withExternalValues(GraphPropertiesParser.parseBundleList(externalValuesString));
        }
        if ((propertiesValuesString = GraphPropertiesParser.getReportProperty(props, key, "propertiesValues", false)) != null) {
            builder.withPropertiesValues(GraphPropertiesParser.parseBundleList(propertiesValuesString));
        }
        if ((typesString = GraphPropertiesParser.getReportProperty(props, key, "type", false)) != null) {
            builder.withTypes(GraphPropertiesParser.parseBundleList(typesString));
        }
        builder.withDescription(GraphPropertiesParser.getReportProperty(props, key, "description", false));
        builder.withGraphWidth(GraphPropertiesParser.getIntegerReportProperty(props, key, "width", false));
        builder.withGraphHeight(GraphPropertiesParser.getIntegerReportProperty(props, key, "height", false));
        String suppressString = GraphPropertiesParser.getReportProperty(props, key, "suppress", false);
        if (suppressString != null) {
            builder.withSupress(GraphPropertiesParser.parseBundleList(suppressString));
        }
        return builder.build();
    }

    private static String getReportProperty(Properties props, String key, String suffix, boolean required) {
        String graphName;
        String propertyName;
        if (key != null) {
            propertyName = "report." + key + "." + suffix;
            graphName = key;
        } else {
            propertyName = "report." + suffix;
            graphName = props.getProperty("report.id");
        }
        String property = props.getProperty(propertyName);
        if (property == null && required) {
            throw new IllegalArgumentException("Properties for report '" + graphName + "' must contain '" + propertyName + "' property");
        }
        return property;
    }

    public static Integer getIntegerReportProperty(Properties props, String key, String suffix, boolean required) {
        String value = GraphPropertiesParser.getReportProperty(props, key, suffix, required);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Property value for '" + suffix + "' on report '" + key + "' must be an integer.  '" + value + "' is not a valid value");
        }
    }

    public static String[] parseBundleList(String list) {
        return GraphPropertiesParser.parseBundleList(list, ",");
    }

    public static String[] parseBundleList(String list, String delimiter) {
        if (list == null || delimiter == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String[] strings = new String[]{};
        StringTokenizer tokenizer = new StringTokenizer(list, delimiter, false);
        int stringCount = tokenizer.countTokens();
        strings = new String[stringCount];
        for (int i = 0; i < stringCount; ++i) {
            strings[i] = tokenizer.nextToken().trim();
        }
        return strings;
    }
}

