/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.beans;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.InMemoryEvent;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.integration.api.v1.model.beans.EventParameterBean;

public class InMemoryEventBean
implements InMemoryEvent {
    private final String uei;
    private final String source;
    private Severity severity;
    private List<EventParameter> parameters;

    public InMemoryEventBean(String uei, String source) {
        this.uei = Objects.requireNonNull(uei);
        this.source = Objects.requireNonNull(source);
    }

    public String getUei() {
        return this.uei;
    }

    public String getSource() {
        return this.source;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public List<EventParameter> getParameters() {
        return this.parameters;
    }

    public Optional<String> getParameterValue(String name) {
        return this.parameters.stream().filter(p -> Objects.equals(name, p.getName())).findFirst().map(EventParameter::getValue);
    }

    public void setParameters(List<EventParameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new LinkedList<EventParameter>();
        }
        this.parameters.add(new EventParameterBean(name, value));
    }

    public List<EventParameter> getParametersByName(String name) {
        if (this.parameters == null) {
            return Collections.emptyList();
        }
        return this.parameters.stream().filter(p -> Objects.equals(name, p.getName())).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemoryEventBean that = (InMemoryEventBean)o;
        return Objects.equals(this.uei, that.uei) && Objects.equals(this.source, that.source) && Objects.equals(this.severity, that.severity) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.uei, this.source, this.severity, this.parameters);
    }

    public String toString() {
        return "InMemoryEventBean{uei='" + this.uei + '\'' + ", source='" + this.source + '\'' + ", severity='" + this.severity + '\'' + ", parameters=" + this.parameters + '}';
    }
}

