/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.requisition.beans;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.config.requisition.Requisition;
import org.opennms.integration.api.v1.config.requisition.RequisitionNode;

public class RequisitionBean
implements Requisition {
    private final String foreignSource;
    private final Date generatedAt;
    private final List<RequisitionNode> nodes;

    public RequisitionBean(Builder builder) {
        this.foreignSource = builder.foreignSource;
        this.generatedAt = builder.generatedAt != null ? builder.generatedAt : new Date();
        this.nodes = Collections.unmodifiableList(builder.nodes != null ? builder.nodes : Collections.emptyList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Date getGeneratedAt() {
        return this.generatedAt;
    }

    public List<RequisitionNode> getNodes() {
        return this.nodes;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequisitionBean that = (RequisitionBean)o;
        return Objects.equals(this.foreignSource, that.foreignSource) && Objects.equals(this.generatedAt, that.generatedAt) && Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.foreignSource, this.generatedAt, this.nodes);
    }

    public String toString() {
        return "RequisitionBean{foreignSource='" + this.foreignSource + '\'' + ", generatedAt=" + this.generatedAt + ", nodes=" + this.nodes + '}';
    }

    public static class Builder {
        private String foreignSource;
        private Date generatedAt;
        private List<RequisitionNode> nodes = new LinkedList<RequisitionNode>();

        public Builder foreignSource(String foreignSource) {
            this.foreignSource = foreignSource;
            return this;
        }

        public Builder generatedAt(Date generatedAt) {
            this.generatedAt = generatedAt;
            return this;
        }

        public Builder nodes(List<RequisitionNode> nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder node(RequisitionNode node) {
            this.nodes.add(node);
            return this;
        }

        public RequisitionBean build() {
            Objects.requireNonNull(this.foreignSource, "foreignSource is required");
            return new RequisitionBean(this);
        }
    }
}

