/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.resource;

import org.opennms.integration.api.v1.collectors.resource.GenericTypeResource;
import org.opennms.integration.api.v1.collectors.resource.IpInterfaceResource;
import org.opennms.integration.api.v1.collectors.resource.NodeResource;
import org.opennms.integration.api.v1.collectors.resource.Resource;

public class ResourceBuilder {
    private Integer nodeId;
    private String foreignSource;
    private String foreignId;
    private String nodeLabel;
    private String location;
    private String instance;
    private String type;

    public ResourceBuilder withNodeId(Integer nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public ResourceBuilder withForeignId(String foreignId) {
        this.foreignId = foreignId;
        return this;
    }

    public ResourceBuilder withForeignSource(String foreignSource) {
        this.foreignSource = foreignSource;
        return this;
    }

    public ResourceBuilder withNodeLabel(String nodeLabel) {
        this.nodeLabel = nodeLabel;
        return this;
    }

    public ResourceBuilder withLocation(String location) {
        this.location = location;
        return this;
    }

    public ResourceBuilder withInstance(String instance) {
        this.instance = instance;
        return this;
    }

    public ResourceBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public NodeResource buildNodeResource() {
        return new NodeResource(){

            @Override
            public Integer getNodeId() {
                return ResourceBuilder.this.nodeId;
            }

            @Override
            public String getForeignSource() {
                return ResourceBuilder.this.foreignSource;
            }

            @Override
            public String getForeignId() {
                return ResourceBuilder.this.foreignId;
            }

            @Override
            public String getNodeLabel() {
                return ResourceBuilder.this.nodeLabel;
            }

            @Override
            public String getLocation() {
                return ResourceBuilder.this.location;
            }

            @Override
            public Resource.Type getResourceType() {
                return Resource.Type.NODE;
            }
        };
    }

    public IpInterfaceResource buildIpInterfaceResource(final NodeResource nodeResource) {
        return new IpInterfaceResource(){

            @Override
            public NodeResource getNodeResource() {
                return nodeResource;
            }

            @Override
            public String getInstance() {
                return ResourceBuilder.this.instance;
            }

            @Override
            public Resource.Type getResourceType() {
                return Resource.Type.INTERFACE;
            }
        };
    }

    public GenericTypeResource buildGenericTypeResource(final NodeResource nodeResource) {
        return new GenericTypeResource(){

            @Override
            public NodeResource getNodeResource() {
                return nodeResource;
            }

            @Override
            public String getType() {
                return ResourceBuilder.this.type;
            }

            @Override
            public String getInstance() {
                return ResourceBuilder.this.instance;
            }

            @Override
            public Resource.Type getResourceType() {
                return Resource.Type.GENERIC;
            }
        };
    }
}

