/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.utils.mate;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.opennms.core.rpc.utils.mate.ContextKey;
import org.opennms.core.rpc.utils.mate.EmptyScope;
import org.opennms.core.rpc.utils.mate.EntityScopeProvider;
import org.opennms.core.rpc.utils.mate.Scope;
import org.opennms.core.rpc.utils.mate.SimpleScope;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionTemplate;

public class EntityScopeProviderImpl
implements EntityScopeProvider {
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao monitoredServiceDao;
    @Autowired
    private TransactionTemplate transactions;

    @Override
    public Scope getScopeForNode(Integer nodeId) {
        if (nodeId == null) {
            return EmptyScope.EMPTY;
        }
        Scope metaDataScope = (Scope)this.transactions.execute(tx -> {
            OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)nodeId);
            if (node == null) {
                return EmptyScope.EMPTY;
            }
            return new SimpleScope(EntityScopeProviderImpl.transform(node.getMetaData()));
        });
        return metaDataScope;
    }

    @Override
    public Scope getScopeForInterface(Integer nodeId, String ipAddress) {
        if (nodeId == null || Strings.isNullOrEmpty((String)ipAddress)) {
            return EmptyScope.EMPTY;
        }
        Scope metaDataScope = (Scope)this.transactions.execute(tx -> {
            OnmsIpInterface ipInterface = this.ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddress);
            if (ipInterface == null) {
                return EmptyScope.EMPTY;
            }
            return new SimpleScope(EntityScopeProviderImpl.transform(ipInterface.getMetaData()));
        });
        return metaDataScope;
    }

    @Override
    public Scope getScopeForService(Integer nodeId, InetAddress ipAddress, String serviceName) {
        if (nodeId == null || ipAddress == null || Strings.isNullOrEmpty((String)serviceName)) {
            return EmptyScope.EMPTY;
        }
        Scope metaDataScope = (Scope)this.transactions.execute(tx -> {
            OnmsMonitoredService monitoredService = this.monitoredServiceDao.get(nodeId, ipAddress, serviceName);
            if (monitoredService == null) {
                return EmptyScope.EMPTY;
            }
            return new SimpleScope(EntityScopeProviderImpl.transform(monitoredService.getMetaData()));
        });
        return metaDataScope;
    }

    private static Map<ContextKey, String> transform(Collection<OnmsMetaData> metaData) {
        return metaData.stream().collect(Collectors.toMap(e -> new ContextKey(e.getContext(), e.getKey()), e -> e.getValue()));
    }
}

