/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.BooleanUtils;
import org.opennms.netmgt.flows.classification.csv.CsvImportResult;
import org.opennms.netmgt.flows.classification.csv.CsvService;
import org.opennms.netmgt.flows.classification.error.Error;
import org.opennms.netmgt.flows.classification.error.Errors;
import org.opennms.netmgt.flows.classification.exception.CSVImportException;
import org.opennms.netmgt.flows.classification.exception.InvalidRuleException;
import org.opennms.netmgt.flows.classification.internal.csv.CsvBuilder;
import org.opennms.netmgt.flows.classification.internal.validation.RuleValidator;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;

public class CsvServiceImpl
implements CsvService {
    public static final String[] HEADERS = new String[]{"name", "protocol", "srcAddress", "srcPort", "dstAddress", "dstPort", "exporterFilter", "omnidirectional"};
    public static final String HEADERS_STRING = String.join((CharSequence)";", HEADERS) + "\n";
    private static final int EXPECTED_COLUMNS = HEADERS.length;
    private final RuleValidator ruleValidator;

    public CsvServiceImpl(RuleValidator ruleValidator) {
        this.ruleValidator = Objects.requireNonNull(ruleValidator);
    }

    public CsvImportResult parseCSV(InputStream inputStream, boolean hasHeader) throws CSVImportException {
        Objects.requireNonNull(inputStream);
        CsvImportResult result = new CsvImportResult();
        try {
            CSVFormat csvFormat = CSVFormat.RFC4180.withDelimiter(';');
            if (hasHeader) {
                csvFormat = csvFormat.withHeader(new String[0]);
            }
            CSVParser parser = csvFormat.parse((Reader)new InputStreamReader(inputStream));
            for (CSVRecord record : parser.getRecords()) {
                if (record.size() < EXPECTED_COLUMNS) {
                    result.markError(record.getRecordNumber(), new Error("entity", Errors.CSV_TOO_FEW_COLUMNS, new Object[]{record.getRecordNumber(), record.toString(), EXPECTED_COLUMNS, record.size()}));
                    continue;
                }
                String name = record.get(0);
                String protocol = record.get(1);
                String srcAddress = record.get(2);
                String srcPort = record.get(3);
                String dstAddress = record.get(4);
                String dstPort = record.get(5);
                String exportFilter = record.get(6);
                String omnidirectional = record.get(7);
                Rule rule = new Rule();
                rule.setName("".equals(name) ? null : name);
                rule.setDstPort("".equals(dstPort) ? null : dstPort);
                rule.setDstAddress("".equals(dstAddress) ? null : dstAddress);
                rule.setSrcPort("".equals(srcPort) ? null : srcPort);
                rule.setSrcAddress("".equals(srcAddress) ? null : srcAddress);
                rule.setProtocol("".equals(protocol) ? null : protocol);
                rule.setExporterFilter("".equals(exportFilter) ? null : exportFilter);
                rule.setOmnidirectional(BooleanUtils.toBoolean((String)omnidirectional));
                try {
                    this.ruleValidator.validate(rule);
                }
                catch (InvalidRuleException ex) {
                    result.markError(record.getRecordNumber(), ex.getError());
                    continue;
                }
                if (result.hasError(record.getRecordNumber())) continue;
                result.markSuccess(rule);
            }
        }
        catch (IOException ex) {
            result.setError(new Error("entity", Errors.CSV_IMPORT_FAILED, new Object[]{ex.getMessage()}));
        }
        return result;
    }

    public String createCSV(List<Rule> rules) {
        String csv = new CsvBuilder().withHeader(true).withRules(rules).build();
        return csv;
    }
}

