/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.ticketing;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.opennms.integration.api.v1.ticketing.Ticket;

public class TicketBuilder {
    private Integer alarmId;
    private Map<String, String> attributes = new HashMap<String, String>();
    private String details;
    private String id;
    private InetAddress ipAddress;
    private Integer nodeId;
    private Ticket.State state;
    private String summary;
    private String user;

    public TicketBuilder withAlarmId(Integer alarmId) {
        this.alarmId = alarmId;
        return this;
    }

    public TicketBuilder withAttributes(Map<String, String> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public TicketBuilder withDetails(String details) {
        this.details = details;
        return this;
    }

    public TicketBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public TicketBuilder withIpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public TicketBuilder withNodeId(Integer nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public TicketBuilder withState(String state) {
        this.state = Ticket.State.valueOf(state);
        return this;
    }

    public TicketBuilder withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public TicketBuilder withUser(String user) {
        this.user = user;
        return this;
    }

    public Ticket build() {
        return new Ticket(){

            @Override
            public String getId() {
                return TicketBuilder.this.id;
            }

            @Override
            public String getUser() {
                return TicketBuilder.this.user;
            }

            @Override
            public Ticket.State getState() {
                return TicketBuilder.this.state;
            }

            @Override
            public Integer getAlarmId() {
                return TicketBuilder.this.alarmId;
            }

            @Override
            public Integer getNodeId() {
                return TicketBuilder.this.nodeId;
            }

            @Override
            public InetAddress getIpAddress() {
                return TicketBuilder.this.ipAddress;
            }

            @Override
            public String getDetails() {
                return TicketBuilder.this.details;
            }

            @Override
            public String getSummary() {
                return TicketBuilder.this.summary;
            }

            @Override
            public Map<String, String> getAttributes() {
                return TicketBuilder.this.attributes;
            }
        };
    }
}

