/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.resource;

import java.util.ArrayList;
import java.util.List;
import org.opennms.integration.api.v1.collectors.resource.CollectionSetResource;
import org.opennms.integration.api.v1.collectors.resource.NumericAttribute;
import org.opennms.integration.api.v1.collectors.resource.Resource;
import org.opennms.integration.api.v1.collectors.resource.StringAttribute;

public class CollectionSetResourceBuilder<T extends Resource> {
    private T resource;
    private List<NumericAttribute> numericAttributes = new ArrayList<NumericAttribute>();
    private List<StringAttribute> stringAttributes = new ArrayList<StringAttribute>();

    public CollectionSetResourceBuilder withResource(T resource) {
        this.resource = resource;
        return this;
    }

    public CollectionSetResourceBuilder withNumericAttribute(NumericAttribute attribute) {
        this.numericAttributes.add(attribute);
        return this;
    }

    public CollectionSetResourceBuilder withStringAttribute(StringAttribute attribute) {
        this.stringAttributes.add(attribute);
        return this;
    }

    public CollectionSetResource<T> build() {
        return new CollectionSetResource<T>(){

            @Override
            public T getResource() {
                return CollectionSetResourceBuilder.this.resource;
            }

            @Override
            public List<StringAttribute> getStringAttributes() {
                return CollectionSetResourceBuilder.this.stringAttributes;
            }

            @Override
            public List<NumericAttribute> getNumericAttributes() {
                return CollectionSetResourceBuilder.this.numericAttributes;
            }
        };
    }
}

