/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.management.internal;

import aQute.bnd.annotation.component.Activate;
import aQute.bnd.annotation.component.Component;
import aQute.bnd.annotation.component.Deactivate;
import aQute.bnd.annotation.component.Reference;
import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.TabularData;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.scr.management.ScrServiceMBean;
import org.apache.karaf.scr.management.codec.JmxComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="ScrServiceMBean", enabled=true, immediate=true, properties={"hidden.component=true"})
public class ScrServiceMBeanImpl
extends StandardMBean
implements ScrServiceMBean {
    public static final String OBJECT_NAME = "org.apache.karaf:type=scr,name=" + System.getProperty("karaf.name", "root");
    public static final String COMPONENT_NAME = "ScrServiceMBean";
    public static final String COMPONENT_LABEL = "Apache Karaf SCR Service MBean";
    private static final Logger LOGGER = LoggerFactory.getLogger(ScrServiceMBeanImpl.class);
    private MBeanServer mBeanServer;
    private ScrService scrService;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public ScrServiceMBeanImpl() throws NotCompliantMBeanException {
        super(ScrServiceMBean.class);
    }

    @Activate
    public void activate() throws Exception {
        LOGGER.info("Activating the Apache Karaf SCR Service MBean");
        HashMap<ScrServiceMBeanImpl, String> mbeans = new HashMap<ScrServiceMBeanImpl, String>();
        mbeans.put(this, "org.apache.karaf:type=scr,name=${karaf.name}");
        try {
            this.lock.writeLock().lock();
            if (this.mBeanServer != null) {
                this.mBeanServer.registerMBean(this, new ObjectName(OBJECT_NAME));
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception registering the SCR Management MBean: " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Deactivate
    public void deactivate() throws Exception {
        LOGGER.info("Deactivating the Apache Karaf SCR Service MBean");
        try {
            this.lock.writeLock().lock();
            if (this.mBeanServer != null) {
                this.mBeanServer.unregisterMBean(new ObjectName(OBJECT_NAME));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public TabularData getComponents() {
        try {
            return JmxComponent.tableFrom(this.safe(this.scrService.getComponents()));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public String[] listComponents() {
        org.apache.felix.scr.Component[] components = this.safe(this.scrService.getComponents());
        String[] componentNames = new String[components.length];
        for (int i = 0; i < componentNames.length; ++i) {
            componentNames[i] = components[i].getName();
        }
        return componentNames;
    }

    @Override
    public boolean isComponentActive(String componentName) throws MBeanException {
        try {
            return this.componentState(componentName) == 16;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public int componentState(String componentName) {
        int state = -1;
        org.apache.felix.scr.Component component = this.findComponent(componentName);
        if (component != null) {
            state = component.getState();
        } else {
            LOGGER.warn("No component found for name: " + componentName);
        }
        return state;
    }

    @Override
    public void activateComponent(String componentName) {
        org.apache.felix.scr.Component component = this.findComponent(componentName);
        if (component != null) {
            component.enable();
        } else {
            LOGGER.warn("No component found for name: " + componentName);
        }
    }

    @Override
    public void deactivateComponent(String componentName) {
        org.apache.felix.scr.Component component = this.findComponent(componentName);
        if (component != null) {
            component.disable();
        } else {
            LOGGER.warn("No component found for name: " + componentName);
        }
    }

    private org.apache.felix.scr.Component findComponent(String componentName) {
        org.apache.felix.scr.Component answer = null;
        if (this.scrService.getComponents(componentName) != null) {
            org.apache.felix.scr.Component[] components = this.scrService.getComponents(componentName);
            org.apache.felix.scr.Component[] componentArray = this.safe(components);
            int n = componentArray.length;
            for (int i = 0; i < n; ++i) {
                org.apache.felix.scr.Component component;
                answer = component = componentArray[i];
            }
        }
        return answer;
    }

    private org.apache.felix.scr.Component[] safe(org.apache.felix.scr.Component[] components) {
        return components == null ? new org.apache.felix.scr.Component[]{} : components;
    }

    @Reference
    public void setmBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public void unsetmBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = null;
    }

    @Reference
    public void setScrService(ScrService scrService) {
        this.scrService = scrService;
    }

    public void unsetScrService(ScrService scrService) {
        this.scrService = null;
    }
}

