/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.common.parser;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.UdpParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardParser
implements UdpParser {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardParser.class);
    private final String name;
    private final AsyncDispatcher<TelemetryMessage> dispatcher;

    public ForwardParser(String name, AsyncDispatcher<TelemetryMessage> dispatcher) {
        this.name = Objects.requireNonNull(name);
        this.dispatcher = Objects.requireNonNull(dispatcher);
    }

    public String getName() {
        return this.name;
    }

    public void start(ScheduledExecutorService executorService) {
    }

    public void stop() {
    }

    public CompletableFuture<?> parse(ByteBuffer buffer, InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws Exception {
        LOG.trace("Got packet from: {}", (Object)remoteAddress);
        TelemetryMessage msg = new TelemetryMessage(remoteAddress, buffer);
        return this.dispatcher.send((Message)msg);
    }
}

