/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.template;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opennms.plugins.elasticsearch.rest.template.TemplateLoader;
import org.opennms.plugins.elasticsearch.rest.template.Version;

public class CachingTemplateLoader
implements TemplateLoader {
    private final LoadingCache<TemplateKey, String> cache;

    public CachingTemplateLoader(final TemplateLoader delegate) {
        Objects.requireNonNull(delegate);
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<TemplateKey, String>(){

            public String load(TemplateKey key) throws Exception {
                return delegate.load(key.getServerVersion(), key.getResource());
            }
        });
    }

    @Override
    public String load(Version serverVersion, String resource) throws IOException {
        try {
            return (String)this.cache.get((Object)new TemplateKey(serverVersion, resource));
        }
        catch (ExecutionException e) {
            throw new IOException("Could not read data from cache", e);
        }
    }

    private static final class TemplateKey {
        private final Version serverVersion;
        private final String resource;

        private TemplateKey(Version serverVersion, String resource) {
            this.serverVersion = serverVersion;
            this.resource = resource;
        }

        private Version getServerVersion() {
            return this.serverVersion;
        }

        private String getResource() {
            return this.resource;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateKey that = (TemplateKey)o;
            return Objects.equals(this.serverVersion, that.serverVersion) && Objects.equals(this.resource, that.resource);
        }

        public int hashCode() {
            return Objects.hash(this.serverVersion, this.resource);
        }
    }
}

