/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.daemon;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.logging.Logging;
import org.opennms.features.telemetry.adapters.registry.api.TelemetryAdapterRegistry;
import org.opennms.netmgt.telemetry.adapters.api.Adapter;
import org.opennms.netmgt.telemetry.adapters.api.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.config.model.Protocol;
import org.opennms.netmgt.telemetry.ipc.TelemetryProtos;
import org.opennms.netmgt.telemetry.ipc.TelemetrySinkModule;
import org.opennms.netmgt.telemetry.listeners.api.TelemetryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TelemetryMessageConsumer
implements MessageConsumer<TelemetryMessage, TelemetryProtos.TelemetryMessageLog> {
    private final Logger LOG = LoggerFactory.getLogger(TelemetryMessageConsumer.class);
    @Autowired
    private TelemetryAdapterRegistry adapterRegistry;
    private final org.opennms.netmgt.telemetry.config.api.Protocol protocolDef;
    private final TelemetrySinkModule sinkModule;
    private final List<org.opennms.netmgt.telemetry.config.api.Adapter> adapterDefs = new ArrayList<org.opennms.netmgt.telemetry.config.api.Adapter>();
    private final List<Adapter> adapters;

    public TelemetryMessageConsumer(Protocol protocol, TelemetrySinkModule sinkModule) throws Exception {
        this((org.opennms.netmgt.telemetry.config.api.Protocol)protocol, protocol.getAdapters().stream().map(adapter -> adapter).collect(Collectors.toList()), sinkModule);
    }

    public TelemetryMessageConsumer(org.opennms.netmgt.telemetry.config.api.Protocol protocolDef, List<org.opennms.netmgt.telemetry.config.api.Adapter> adapterDef, TelemetrySinkModule sinkModule) {
        this.protocolDef = Objects.requireNonNull(protocolDef);
        this.sinkModule = Objects.requireNonNull(sinkModule);
        this.adapters = new ArrayList<Adapter>(adapterDef.size());
        this.adapterDefs.addAll(adapterDef);
    }

    @PostConstruct
    public void init() throws Exception {
        for (org.opennms.netmgt.telemetry.config.api.Adapter adapterDef : this.adapterDefs) {
            Adapter adapter;
            try {
                adapter = this.adapterRegistry.getAdapter(adapterDef.getClassName(), this.protocolDef, adapterDef.getParameterMap());
            }
            catch (Exception e) {
                throw new Exception("Failed to create adapter from definition: " + adapterDef, e);
            }
            if (adapter == null) {
                throw new Exception("No adapter found for class: " + adapterDef.getClassName());
            }
            this.adapters.add(adapter);
        }
    }

    public void handleMessage(TelemetryProtos.TelemetryMessageLog messageLog) {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"telemetryd");){
            this.LOG.trace("Received message log: {}", (Object)messageLog);
            for (Adapter adapter : this.adapters) {
                try {
                    adapter.handleMessageLog((TelemetryMessageLog)messageLog);
                }
                catch (RuntimeException e) {
                    this.LOG.warn("Adapter: {} failed to handle message log: {}. Skipping.", new Object[]{adapter, messageLog, e});
                }
            }
        }
    }

    @PreDestroy
    public void destroy() {
        this.adapters.forEach(adapter -> adapter.destroy());
    }

    public SinkModule<TelemetryMessage, TelemetryProtos.TelemetryMessageLog> getModule() {
        return this.sinkModule;
    }

    public org.opennms.netmgt.telemetry.config.api.Protocol getProtocol() {
        return this.protocolDef;
    }

    public void setAdapterRegistry(TelemetryAdapterRegistry adapterRegistry) {
        this.adapterRegistry = adapterRegistry;
    }
}

