/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.value;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class StringValue {
    private final String input;

    public StringValue(String input) {
        this.input = input;
    }

    public boolean hasWildcard() {
        return this.input != null && this.input.contains("*");
    }

    public boolean isWildcard() {
        return "*".equals(this.input);
    }

    public boolean isNull() {
        return this.input == null;
    }

    public boolean isEmpty() {
        return this.input != null && this.input.isEmpty();
    }

    public boolean isNullOrEmpty() {
        return this.isNull() || this.isEmpty();
    }

    public boolean isRanged() {
        if (!this.isNullOrEmpty()) {
            return this.input.contains("-");
        }
        return false;
    }

    public String getValue() {
        return this.input;
    }

    public List<StringValue> splitBy(String separator) {
        return Arrays.stream(this.input.split(separator)).map(segment -> segment.trim()).filter(segment -> segment != null && segment.length() > 0).map(segment -> new StringValue((String)segment)).collect(Collectors.toList());
    }
}

