/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.adapters.collection;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.opennms.features.osgi.script.OSGiScriptEngineManager;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.osgi.framework.BundleContext;

public class ScriptedCollectionSetBuilder {
    private CompiledScript compiledScript;

    public ScriptedCollectionSetBuilder(File script) throws IOException, ScriptException {
        this(script, new ScriptEngineManager());
    }

    public ScriptedCollectionSetBuilder(File script, BundleContext bundleContext) throws IOException, ScriptException {
        this(script, (ScriptEngineManager)new OSGiScriptEngineManager(bundleContext));
    }

    public ScriptedCollectionSetBuilder(File script, ScriptEngineManager manager) throws IOException, ScriptException {
        if (!script.canRead()) {
            throw new IllegalStateException("Cannot read script at '" + script + "'.");
        }
        String ext = Files.getFileExtension((String)script.getAbsolutePath());
        ScriptEngine engine = manager.getEngineByExtension(ext);
        if (engine == null) {
            throw new IllegalStateException("No engine found for extension: " + ext);
        }
        if (!(engine instanceof Compilable)) {
            throw new IllegalStateException("Only engines that can compile scripts are supported.");
        }
        Compilable compilable = (Compilable)((Object)engine);
        try (FileReader reader = new FileReader(script);){
            this.compiledScript = compilable.compile(reader);
        }
    }

    public CollectionSet build(CollectionAgent agent, Object message) throws ScriptException {
        CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        SimpleBindings globals = new SimpleBindings();
        globals.put("agent", (Object)agent);
        globals.put("builder", (Object)builder);
        globals.put("msg", message);
        this.compiledScript.eval(globals);
        return builder.build();
    }
}

