/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.opennms.netmgt.model.OnmsAlarm;

@Entity
@Table(name="alarm_situations", uniqueConstraints={@UniqueConstraint(columnNames={"situation_id", "related_alarm_id"})})
public class AlarmAssociation
implements Serializable {
    private static final long serialVersionUID = 4115687014888009683L;
    private Integer id;
    private OnmsAlarm situationAlarm;
    private OnmsAlarm relatedAlarm;
    private Date mappedTime;

    public AlarmAssociation() {
    }

    public AlarmAssociation(OnmsAlarm situationAlarm, OnmsAlarm relatedAlarm) {
        this(situationAlarm, relatedAlarm, new Date());
    }

    public AlarmAssociation(OnmsAlarm situationAlarm, OnmsAlarm relatedAlarm, Date mappedTime) {
        this.mappedTime = mappedTime;
        this.situationAlarm = situationAlarm;
        this.relatedAlarm = relatedAlarm;
    }

    @Id
    @SequenceGenerator(name="alarmSequence", sequenceName="alarmsNxtId")
    @GeneratedValue(generator="alarmSequence")
    @Column(name="id", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="situation_id")
    public OnmsAlarm getSituationAlarm() {
        return this.situationAlarm;
    }

    public void setSituationAlarm(OnmsAlarm situationAlarm) {
        this.situationAlarm = situationAlarm;
    }

    @OneToOne
    @JoinColumn(name="related_alarm_id")
    public OnmsAlarm getRelatedAlarm() {
        return this.relatedAlarm;
    }

    public void setRelatedAlarm(OnmsAlarm relatedAlarm) {
        this.relatedAlarm = relatedAlarm;
    }

    public void setMappedTime(Date mappedTime) {
        this.mappedTime = mappedTime;
    }

    @Column(name="mapped_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getMappedTime() {
        return this.mappedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlarmAssociation that = (AlarmAssociation)o;
        return Objects.equals(this.situationAlarm, that.situationAlarm) && Objects.equals(this.relatedAlarm, that.relatedAlarm);
    }

    public int hashCode() {
        return Objects.hash(this.situationAlarm, this.relatedAlarm);
    }
}

