/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.cassandra.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaManager
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaManager.class);
    private static final String KEYSPACE_PLACEHOLDER = "$KEYSPACE$";
    private static final String REPLICATION_FACTOR_PLACEHOLDER = "$REPLICATION_FACTOR$";
    public static final int DEFAULT_REPLICATION_FACTOR = 1;
    private String m_keyspace;
    private Cluster m_cluster;
    private Session m_session;
    private int m_replicationFactor = 1;

    @Inject
    public SchemaManager(@Named(value="cassandra.keyspace") String keyspace, @Named(value="cassandra.host") String host, @Named(value="cassandra.port") int port, @Named(value="cassandra.username") String username, @Named(value="cassandra.password") String password, @Named(value="cassandra.ssl") boolean ssl) {
        this.m_keyspace = keyspace;
        Cluster.Builder builder = Cluster.builder().withPort(port).addContactPoints(host.split(","));
        if (username != null && password != null) {
            LOG.info("Using username: {} and password: XXXXXXXX", (Object)username);
            builder.withCredentials(username, password);
        }
        if (ssl) {
            LOG.info("Using SSL.");
            builder.withSSL();
        }
        this.m_cluster = builder.build();
        this.m_session = this.m_cluster.connect();
    }

    public void create(Schema schema) throws IOException {
        this.create(schema, true);
    }

    public void create(Schema schema, boolean ifNotExists) throws IOException {
        this.create(schema, ifNotExists, false);
    }

    public void create(Schema schema, boolean ifNotExists, boolean printOnly) throws IOException {
        String line;
        Preconditions.checkNotNull((Object)schema, (Object)"schema argument");
        InputStream stream = (InputStream)Preconditions.checkNotNull((Object)schema.getInputStream(), (Object)"schema input stream");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        StringBuilder statement = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            String scrubbed = SchemaManager.scrub(line);
            statement.append(scrubbed);
            if (!scrubbed.endsWith(";")) continue;
            String queryString = statement.toString().replace(KEYSPACE_PLACEHOLDER, this.m_keyspace);
            queryString = queryString.replace(REPLICATION_FACTOR_PLACEHOLDER, Integer.toString(this.m_replicationFactor));
            if (printOnly) {
                System.err.println(queryString);
            } else {
                try {
                    this.m_session.execute(queryString);
                }
                catch (AlreadyExistsException e) {
                    if (ifNotExists) {
                        System.err.printf("%s; Nothing here to do%n", e.getLocalizedMessage());
                    }
                    throw e;
                }
                catch (SyntaxError e) {
                    System.out.printf("ERROR: %s (query: \"%s\").%n", e.getLocalizedMessage(), queryString);
                    throw e;
                }
            }
            statement = new StringBuilder();
        }
    }

    private static String scrub(String line) {
        return line.replace("\\s+", "").replace("//.*$", "").replace(";.*$", ";");
    }

    @Override
    public void close() {
        this.m_cluster.close();
    }

    public int getReplicationFactor() {
        return this.m_replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.m_replicationFactor = replicationFactor;
    }
}

